/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;

public abstract class BaseCalendarRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        UICalendar uicalendar = (UICalendar)component;
        if (!this.shouldDecode((UIInput)uicalendar)) {
            return;
        }
        String param = uicalendar.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(param);
        if (submittedValue != null) {
            uicalendar.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, (UIComponent)uicalendar);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UICalendar uicalendar = (UICalendar)component;
        String markupValue = CalendarUtils.getValueAsString(context, uicalendar);
        String widgetValue = uicalendar.isTimeOnly() ? CalendarUtils.getTimeOnlyValueAsString(context, uicalendar) : markupValue;
        uicalendar.validateMinMax(context);
        this.encodeMarkup(context, uicalendar, markupValue);
        this.encodeScript(context, uicalendar, widgetValue);
    }

    protected abstract void encodeMarkup(FacesContext var1, UICalendar var2, String var3) throws IOException;

    protected abstract void encodeScript(FacesContext var1, UICalendar var2, String var3) throws IOException;

    protected void encodeInput(FacesContext context, UICalendar uicalendar, String id, String value, boolean popup) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String type = popup ? uicalendar.getType() : "hidden";
        String inputStyle = uicalendar.getInputStyle();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)type, null);
        if (!this.isValueBlank(value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        boolean readonly = false;
        boolean disabled = false;
        if (popup) {
            String inputStyleClass = this.createStyleClass((UIInput)uicalendar, UICalendar.PropertyKeys.inputStyleClass.name(), "ui-inputfield ui-widget ui-state-default ui-corner-all");
            readonly = uicalendar.isReadonly() || uicalendar.isReadonlyInput();
            disabled = uicalendar.isDisabled();
            writer.writeAttribute("class", (Object)inputStyleClass, null);
            if (inputStyle != null) {
                writer.writeAttribute("style", (Object)inputStyle, null);
            }
            this.renderPassThruAttributes(context, (UIComponent)uicalendar, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
            this.renderDomEvents(context, (UIComponent)uicalendar, HTML.INPUT_TEXT_EVENTS);
        }
        this.renderAccessibilityAttributes(context, (UIInput)uicalendar, disabled, readonly);
        this.renderValidationMetadata(context, (EditableValueHolder)uicalendar);
        writer.endElement("input");
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        String submittedValue;
        String string = submittedValue = this.isValueBlank((String)value) ? null : ((String)value).trim();
        if (submittedValue == null) {
            return null;
        }
        UICalendar calendar = (UICalendar)component;
        Class<?> type = this.resolveDateType(context, calendar);
        if (type != null) {
            Converter converter = this.resolveConverter(context, calendar, type);
            if (converter != null) {
                try {
                    return converter.getAsObject(context, (UIComponent)calendar, submittedValue);
                }
                catch (ConverterException e) {
                    calendar.setConversionFailed(true);
                    throw e;
                }
            }
            if (Temporal.class.isAssignableFrom(type)) {
                if (calendar.getTimeZone() != null) {
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "'timeZone' attribute is not supported for " + type.getName() + ". Use an explicit converter instead of the built-in.", null);
                    throw new ConverterException(message);
                }
                return this.convertToJava8DateTimeAPI(context, calendar, type, submittedValue);
            }
            if (Date.class.isAssignableFrom(type)) {
                return this.convertToLegacyDateAPI(context, calendar, submittedValue);
            }
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, type.getName() + " not supported", null);
            throw new ConverterException(message);
        }
        return null;
    }

    protected Date convertToLegacyDateAPI(FacesContext context, UICalendar calendar, String submittedValue) {
        SimpleDateFormat format = new SimpleDateFormat(calendar.calculatePattern(), calendar.calculateLocale(context));
        format.setLenient(false);
        format.setTimeZone(TimeZone.getTimeZone(CalendarUtils.calculateZoneId(calendar.getTimeZone())));
        try {
            return format.parse(submittedValue);
        }
        catch (ParseException e) {
            throw this.createConverterException(context, calendar, submittedValue, format.format(new Date()));
        }
    }

    protected Temporal convertToJava8DateTimeAPI(FacesContext context, UICalendar calendar, Class<?> type, String submittedValue) {
        if (type == LocalDate.class || type == YearMonth.class) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(calendar.calculatePattern()).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.ERA, 1L).toFormatter(calendar.calculateLocale(context)).withZone(CalendarUtils.calculateZoneId(calendar.getTimeZone())).withResolverStyle(this.resolveResolverStyle(calendar.getResolverStyle()));
            try {
                return type == LocalDate.class ? LocalDate.parse(submittedValue, formatter) : YearMonth.parse(submittedValue, formatter);
            }
            catch (DateTimeParseException e) {
                throw this.createConverterException(context, calendar, submittedValue, formatter.format(LocalDateTime.now()));
            }
        }
        if (type == LocalTime.class) {
            String pattern = calendar instanceof Calendar ? calendar.calculatePattern() : calendar.calculateTimeOnlyPattern();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, calendar.calculateLocale(context)).withZone(CalendarUtils.calculateZoneId(calendar.getTimeZone())).withResolverStyle(this.resolveResolverStyle(calendar.getResolverStyle()));
            try {
                return LocalTime.parse(submittedValue, formatter);
            }
            catch (DateTimeParseException e) {
                throw this.createConverterException(context, calendar, submittedValue, formatter.format(LocalDateTime.now()));
            }
        }
        if (type == LocalDateTime.class) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(calendar.calculatePattern()).parseDefaulting(ChronoField.ERA, 1L).toFormatter(calendar.calculateLocale(context)).withZone(CalendarUtils.calculateZoneId(calendar.getTimeZone())).withResolverStyle(this.resolveResolverStyle(calendar.getResolverStyle()));
            try {
                return LocalDateTime.parse(submittedValue, formatter);
            }
            catch (DateTimeParseException e) {
                throw this.createConverterException(context, calendar, submittedValue, formatter.format(LocalDateTime.now()));
            }
        }
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, type.getName() + " not supported", null);
        throw new ConverterException(message);
    }

    private ResolverStyle resolveResolverStyle(String passedResolverStyle) {
        for (ResolverStyle resolverStyle : ResolverStyle.values()) {
            if (!resolverStyle.name().equalsIgnoreCase(passedResolverStyle)) continue;
            return resolverStyle;
        }
        return ResolverStyle.SMART;
    }

    protected ConverterException createConverterException(FacesContext context, UICalendar calendar, String submittedValue, Object param1) {
        calendar.setConversionFailed(true);
        FacesMessage message = null;
        Object[] params = new Object[]{submittedValue, param1, ComponentUtils.getLabel(context, (UIComponent)calendar)};
        message = calendar.isTimeOnly() ? MessageFactory.getFacesMessage("jakarta.faces.converter.DateTimeConverter.TIME", FacesMessage.SEVERITY_ERROR, params) : (calendar.hasTime() ? MessageFactory.getFacesMessage("jakarta.faces.converter.DateTimeConverter.DATETIME", FacesMessage.SEVERITY_ERROR, params) : MessageFactory.getFacesMessage("jakarta.faces.converter.DateTimeConverter.DATE", FacesMessage.SEVERITY_ERROR, params));
        return new ConverterException(message);
    }

    protected Class<?> resolveDateType(FacesContext context, UICalendar calendar) {
        ValueExpression ve = calendar.getValueExpression("value");
        Class type = null;
        if (ve != null) {
            type = ve.getType(context.getELContext());
        }
        if (type == null || type.equals(Object.class)) {
            type = calendar.isTimeOnly() ? LocalTime.class : (calendar.hasTime() ? LocalDateTime.class : LocalDate.class);
        } else if (Collection.class.isAssignableFrom(type)) {
            ValueReference valueReference = ValueExpressionAnalyzer.getReference(context.getELContext(), ve);
            Object base = valueReference.getBase();
            Object property = valueReference.getProperty();
            type = LangUtils.getTypeFromCollectionProperty(base, (String)property);
        }
        return type;
    }

    protected Converter resolveConverter(FacesContext context, UICalendar calendar, Class<?> type) {
        Converter converter = calendar.getConverter();
        if (converter != null) {
            return converter;
        }
        if (type != null && type != Object.class && type != Date.class && type != LocalDate.class && type != YearMonth.class && type != LocalDateTime.class && type != LocalTime.class) {
            converter = context.getApplication().createConverter(type);
        }
        return converter;
    }
}

