/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.primefaces.PrimeFaces;
import org.primefaces.component.captcha.CaptchaBase;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="captcha/captcha.js")})
public class Captcha
extends CaptchaBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Captcha";
    public static final String PUBLIC_KEY = "primefaces.PUBLIC_CAPTCHA_KEY";
    public static final String PRIVATE_KEY = "primefaces.PRIVATE_CAPTCHA_KEY";
    public static final String INVALID_MESSAGE_ID = "primefaces.captcha.INVALID";

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (this.isValid()) {
            boolean result = false;
            try {
                URL url = new URL("https://www.google.com/recaptcha/api/siteverify");
                URLConnection conn = url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String postBody = this.createPostParameters(context, value);
                try (OutputStream out = conn.getOutputStream();){
                    out.write(postBody.getBytes());
                    out.flush();
                }
                try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String inputLine;
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = rd.readLine()) != null) {
                        response.append(inputLine);
                    }
                    JSONObject json = new JSONObject(response.toString());
                    result = json.getBoolean("success");
                }
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
            finally {
                if (context.getPartialViewContext().isAjaxRequest()) {
                    PrimeFaces.current().executeScript("if (document.getElementById('g-recaptcha-response')) { try { grecaptcha.reset(); } catch (error) { PrimeFaces.error(error); } }");
                }
            }
            if (!result) {
                this.setValid(false);
                String validatorMessage = this.getValidatorMessage();
                FacesMessage msg = null;
                if (validatorMessage != null) {
                    msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage);
                } else {
                    Object[] params = new Object[]{ComponentUtils.getLabel(context, (UIComponent)this), value};
                    msg = MessageFactory.getFacesMessage(INVALID_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, params);
                }
                context.addMessage(this.getClientId(context), msg);
            }
        }
    }

    private String createPostParameters(FacesContext context, Object value) throws UnsupportedEncodingException {
        String privateKey = (String)context.getApplication().evaluateExpressionGet(context, context.getExternalContext().getInitParameter(PRIVATE_KEY), String.class);
        if (privateKey == null) {
            throw new FacesException("Cannot find private key for catpcha, use primefaces.PRIVATE_CAPTCHA_KEY context-param to define one");
        }
        StringBuilder postParams = new StringBuilder();
        postParams.append("secret=").append(URLEncoder.encode(privateKey, "UTF-8"));
        postParams.append("&response=").append(value == null ? "" : URLEncoder.encode((String)value, "UTF-8"));
        String params = postParams.toString();
        postParams.setLength(0);
        return params;
    }
}

