/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.card;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.card.Card;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public class CardRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String header;
        Card card = (Card)component;
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-card ui-widget ui-widget-content ui-corner-all").add(card.getStyleClass()).build();
        UIComponent headerFacet = card.getFacet("header");
        UIComponent titleFacet = card.getFacet("title");
        UIComponent subtitleFacet = card.getFacet("subtitle");
        UIComponent footerFacet = card.getFacet("footer");
        writer.startElement("div", (UIComponent)card);
        writer.writeAttribute("id", (Object)card.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (card.getStyle() != null) {
            writer.writeAttribute("style", (Object)card.getStyle(), "style");
        }
        if (LangUtils.isNotBlank(header = card.getHeader())) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-header", null);
            writer.writeText((Object)header, null);
            writer.endElement("div");
        } else if (ComponentUtils.shouldRenderFacet(headerFacet)) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-header", null);
            headerFacet.encodeAll(context);
            writer.endElement("div");
        }
        writer.startElement("div", (UIComponent)card);
        writer.writeAttribute("class", (Object)"ui-card-body", null);
        String title = card.getTitle();
        if (LangUtils.isNotBlank(title)) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-title", null);
            writer.writeText((Object)title, null);
            writer.endElement("div");
        } else if (ComponentUtils.shouldRenderFacet(titleFacet)) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-title", null);
            titleFacet.encodeAll(context);
            writer.endElement("div");
        }
        String subtitle = card.getSubtitle();
        if (LangUtils.isNotBlank(title)) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-subtitle", null);
            writer.writeText((Object)subtitle, null);
            writer.endElement("div");
        } else if (ComponentUtils.shouldRenderFacet(subtitleFacet)) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-subtitle", null);
            subtitleFacet.encodeAll(context);
            writer.endElement("div");
        }
        writer.startElement("div", (UIComponent)card);
        writer.writeAttribute("class", (Object)"ui-card-content", null);
        this.renderChildren(context, (UIComponent)card);
        writer.endElement("div");
        String footer = card.getSubtitle();
        if (LangUtils.isNotBlank(footer)) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-footer", null);
            writer.writeText((Object)footer, null);
            writer.endElement("div");
        } else if (ComponentUtils.shouldRenderFacet(footerFacet)) {
            writer.startElement("div", (UIComponent)card);
            writer.writeAttribute("class", (Object)"ui-card-footer", null);
            footerFacet.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) {
    }
}

