/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.primefaces.component.chart.Chart;
import org.primefaces.component.chart.renderer.BarRenderer;
import org.primefaces.component.chart.renderer.BasePlotRenderer;
import org.primefaces.component.chart.renderer.BubbleRenderer;
import org.primefaces.component.chart.renderer.DonutRenderer;
import org.primefaces.component.chart.renderer.LineRenderer;
import org.primefaces.component.chart.renderer.MeterGaugeRenderer;
import org.primefaces.component.chart.renderer.OhlcRenderer;
import org.primefaces.component.chart.renderer.PieRenderer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ChartRenderer
extends CoreRenderer {
    private static final String TYPE_PIE = "pie";
    private static final String TYPE_LINE = "line";
    private static final String TYPE_BAR = "bar";
    private static final String TYPE_OHLC = "ohlc";
    private static final String TYPE_DONUT = "donut";
    private static final String TYPE_BUBBLE = "bubble";
    private static final String TYPE_METERGAUGE = "metergauge";
    private static final Map<String, BasePlotRenderer> CHART_RENDERERS = new HashMap<String, BasePlotRenderer>();

    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Chart chart = (Chart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeMarkup(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = chart.getStyle();
        String styleClass = chart.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)chart.getClientId(context), null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Chart chart) throws IOException {
        String type = chart.getType();
        BasePlotRenderer plotRenderer = CHART_RENDERERS.get(type);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Chart", chart).attr("type", type);
        if (chart.isResponsive()) {
            wb.attr("responsive", true);
        }
        plotRenderer.render(context, chart);
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    static {
        CHART_RENDERERS.put(TYPE_PIE, new PieRenderer());
        CHART_RENDERERS.put(TYPE_LINE, new LineRenderer());
        CHART_RENDERERS.put(TYPE_BAR, new BarRenderer());
        CHART_RENDERERS.put(TYPE_OHLC, new OhlcRenderer());
        CHART_RENDERERS.put(TYPE_DONUT, new DonutRenderer());
        CHART_RENDERERS.put(TYPE_BUBBLE, new BubbleRenderer());
        CHART_RENDERERS.put(TYPE_METERGAUGE, new MeterGaugeRenderer());
    }
}

