/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.renderer;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.primefaces.component.chart.Chart;
import org.primefaces.component.chart.renderer.CartesianPlotRenderer;
import org.primefaces.model.chart.BubbleChartModel;
import org.primefaces.model.chart.BubbleChartSeries;

public class BubbleRenderer
extends CartesianPlotRenderer {
    @Override
    protected void encodeData(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BubbleChartModel model = (BubbleChartModel)chart.getModel();
        List<BubbleChartSeries> data = model.getData();
        writer.write(",data:[[");
        Iterator<BubbleChartSeries> it = data.iterator();
        while (it.hasNext()) {
            BubbleChartSeries s = it.next();
            writer.write("[");
            writer.write(this.escapeChartData(s.getX()));
            writer.write(",");
            writer.write(this.escapeChartData(s.getY()));
            writer.write(",");
            writer.write(this.escapeChartData(s.getRadius()));
            writer.write(",");
            writer.write(this.escapeChartData(s.getLabel()));
            writer.write("]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]]");
    }

    @Override
    protected void encodeOptions(FacesContext context, Chart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        BubbleChartModel model = (BubbleChartModel)chart.getModel();
        writer.write(",showLabels:" + model.isShowLabels());
        writer.write(",bubbleGradients:" + model.isBubbleGradients());
        writer.write(",bubbleAlpha:" + model.getBubbleAlpha());
        if (model.isZoom()) {
            writer.write(",zoom:true");
        }
        if (model.isShowDatatip()) {
            writer.write(",datatip:true");
            if (model.getDatatipFormat() != null) {
                writer.write(",datatipFormat:\"" + model.getDatatipFormat() + "\"");
            }
        }
    }
}

