/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.renderer;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.primefaces.component.chart.Chart;
import org.primefaces.component.chart.renderer.CartesianPlotRenderer;
import org.primefaces.model.chart.OhlcChartModel;
import org.primefaces.model.chart.OhlcChartSeries;

public class OhlcRenderer
extends CartesianPlotRenderer {
    @Override
    protected void encodeData(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OhlcChartModel model = (OhlcChartModel)chart.getModel();
        List<OhlcChartSeries> data = model.getData();
        writer.write(",data:[[");
        Iterator<OhlcChartSeries> it = data.iterator();
        while (it.hasNext()) {
            OhlcChartSeries s = it.next();
            writer.write("[");
            writer.write(this.escapeChartData(s.getValue()));
            writer.write(",");
            writer.write(this.escapeChartData(s.getOpen()));
            writer.write(",");
            writer.write(this.escapeChartData(s.getHigh()));
            writer.write(",");
            writer.write(this.escapeChartData(s.getLow()));
            writer.write(",");
            writer.write(this.escapeChartData(s.getClose()));
            writer.write("]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]]");
    }

    @Override
    protected void encodeOptions(FacesContext context, Chart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        OhlcChartModel model = (OhlcChartModel)chart.getModel();
        if (model.isCandleStick()) {
            writer.write(",candleStick:true");
        }
        if (model.isZoom()) {
            writer.write(",zoom:true");
        }
        if (model.isAnimate()) {
            writer.write(",animate:true");
        }
        if (model.isShowDatatip()) {
            writer.write(",datatip:true");
            if (model.getDatatipFormat() != null) {
                writer.write(",datatipFormat:\"" + model.getDatatipFormat() + "\"");
            }
        }
    }
}

