/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chip;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.chip.Chip;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ChipRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Chip chip = (Chip)component;
        this.encodeMarkup(context, chip);
        this.encodeScript(context, chip);
    }

    protected void encodeMarkup(FacesContext context, Chip chip) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-chip ui-widget").add(chip.getStyleClass()).add(chip.getImage() != null, "ui-chip-image").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)chip.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (chip.getStyle() != null) {
            writer.writeAttribute("style", (Object)chip.getStyle(), "style");
        }
        if (chip.getChildCount() > 0) {
            this.renderChildren(context, (UIComponent)chip);
        } else {
            this.encodeDefaultContent(context, chip);
        }
        writer.endElement("div");
    }

    protected void encodeDefaultContent(FacesContext context, Chip chip) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (chip.getImage() != null) {
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)chip.getImage(), null);
            writer.endElement("img");
        } else if (chip.getIcon() != null) {
            String iconStyleClass = this.getStyleClassBuilder(context).add("ui-chip-icon").add(chip.getIcon()).build();
            writer.startElement("span", (UIComponent)chip);
            writer.writeAttribute("class", (Object)iconStyleClass, null);
            writer.endElement("span");
        }
        if (chip.getLabel() != null) {
            writer.startElement("div", (UIComponent)chip);
            writer.writeAttribute("class", (Object)"ui-chip-text", null);
            writer.write(chip.getLabel());
            writer.endElement("div");
        }
        if (chip.getRemovable()) {
            String removeIconStyleClass = this.getStyleClassBuilder(context).add("ui-chip-remove-icon").add(chip.getRemoveIcon()).build();
            writer.startElement("span", (UIComponent)chip);
            writer.writeAttribute("tabindex", (Object)"0", null);
            writer.writeAttribute("class", (Object)removeIconStyleClass, null);
            writer.endElement("span");
        }
    }

    protected void encodeScript(FacesContext context, Chip chip) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Chip", chip);
        this.encodeClientBehaviors(context, chip);
        wb.finish();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) {
    }
}

