/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.collector;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.util.Collection;

public class Collector
implements ActionListener,
StateHolder {
    private ValueExpression addTo;
    private ValueExpression removeFrom;
    private ValueExpression value;
    private ValueExpression unique;
    private boolean _transient;

    public Collector() {
    }

    public Collector(ValueExpression addTo, ValueExpression removeFrom, ValueExpression value, ValueExpression unique) {
        this.addTo = addTo;
        this.removeFrom = removeFrom;
        this.value = value;
        this.unique = unique;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (this.value == null) {
            throw new AbortProcessingException("Value has not been set");
        }
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        Object val = this.value.getValue(elContext);
        if (this.addTo != null) {
            boolean checkUniqueness;
            Collection collection = (Collection)this.addTo.getValue(elContext);
            Object uniqueValue = this.unique != null ? this.unique.getValue(elContext) : null;
            boolean bl = checkUniqueness = uniqueValue == null || Boolean.parseBoolean(uniqueValue.toString());
            if (checkUniqueness) {
                if (!collection.contains(val)) {
                    collection.add(val);
                }
            } else {
                collection.add(val);
            }
        } else if (this.removeFrom != null) {
            Collection collection = (Collection)this.removeFrom.getValue(elContext);
            collection.remove(val);
        } else {
            throw new IllegalArgumentException("Specify either addTo or removeFrom as collection reference");
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.addTo, this.removeFrom, this.value, this.unique};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.addTo = (ValueExpression)values[0];
        this.removeFrom = (ValueExpression)values[1];
        this.value = (ValueExpression)values[2];
        this.unique = (ValueExpression)values[3];
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public ValueExpression getAddTo() {
        return this.addTo;
    }

    public void setAddTo(ValueExpression addTo) {
        this.addTo = addTo;
    }

    public ValueExpression getRemoveFrom() {
        return this.removeFrom;
    }

    public void setRemoveFrom(ValueExpression removeFrom) {
        this.removeFrom = removeFrom;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getUnique() {
        return this.unique;
    }

    public void setUnique(ValueExpression unique) {
        this.unique = unique;
    }
}

