/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.collector;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import org.primefaces.component.collector.Collector;

public class CollectorTagHandler
extends TagHandler {
    private final TagAttribute addTo = this.getAttribute("addTo");
    private final TagAttribute removeFrom = this.getAttribute("removeFrom");
    private final TagAttribute value = this.getRequiredAttribute("value");
    private final TagAttribute unique = this.getAttribute("unique");

    public CollectorTagHandler(TagConfig tagConfig) {
        super(tagConfig);
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        ValueExpression addToVE = null;
        ValueExpression removeFromVE = null;
        ValueExpression uniqueVE = null;
        if (this.addTo != null) {
            addToVE = this.addTo.getValueExpression(faceletContext, Object.class);
        }
        if (this.removeFrom != null) {
            removeFromVE = this.removeFrom.getValueExpression(faceletContext, Object.class);
        }
        if (this.unique != null) {
            uniqueVE = this.unique.getValueExpression(faceletContext, Object.class);
        }
        ValueExpression valueVE = this.value.getValueExpression(faceletContext, Object.class);
        ActionSource actionSource = (ActionSource)parent;
        actionSource.addActionListener((ActionListener)new Collector(addToVE, removeFromVE, valueVE, uniqueVE));
    }
}

