/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.colorpicker;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.primefaces.component.colorpicker.ColorPicker;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class ColorPickerRenderer
extends InputRenderer {
    private static final Pattern COLOR_HEX_PATTERN = Pattern.compile("([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})");

    public void decode(FacesContext context, UIComponent component) {
        ColorPicker colorPicker = (ColorPicker)component;
        if (!this.shouldDecode(colorPicker)) {
            return;
        }
        String paramName = colorPicker.getClientId(context) + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(paramName)) {
            String submittedValue = (String)params.get(paramName);
            if (!COLOR_HEX_PATTERN.matcher(submittedValue).matches()) {
                submittedValue = "";
            }
            colorPicker.setSubmittedValue(ComponentUtils.getConvertedValue(context, component, submittedValue));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ColorPicker colorPicker = (ColorPicker)component;
        Converter converter = ComponentUtils.getConverter(context, component);
        String value = converter != null ? converter.getAsString(context, component, colorPicker.getValue()) : (String)colorPicker.getValue();
        this.encodeMarkup(context, colorPicker, value);
        this.encodeScript(context, colorPicker, value);
    }

    protected void encodeMarkup(FacesContext context, ColorPicker colorPicker, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = colorPicker.getClientId(context);
        String inputId = clientId + "_input";
        boolean isPopup = colorPicker.getMode().equals("popup");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)this.createStyleClass(colorPicker, "ui-colorpicker"), "styleClass");
        if (colorPicker.getStyle() != null) {
            writer.writeAttribute("style", (Object)colorPicker.getStyle(), "style");
        }
        if (isPopup) {
            this.encodeButton(context, colorPicker, clientId, value);
        } else {
            this.encodeInline(context, colorPicker, clientId);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        String onchange = colorPicker.getOnchange();
        if (!this.isValueBlank(onchange)) {
            writer.writeAttribute("onchange", (Object)onchange, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)colorPicker, new List[0]);
        this.renderValidationMetadata(context, (EditableValueHolder)colorPicker);
        this.renderAccessibilityAttributes(context, colorPicker);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, ColorPicker colorPicker, String clientId, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)"ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only", null);
        this.renderAccessibilityAttributes(context, colorPicker);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("<span id=\"" + clientId + "_livePreview\" style=\"overflow:hidden;width:1em;height:1em;display:block;border:solid 1px #000;text-indent:1em;white-space:nowrap;");
        if (value != null) {
            writer.write("background-color:#" + value);
        }
        writer.write("\">Live Preview</span>");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeInline(FacesContext context, ColorPicker colorPicker, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_inline"), "id");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ColorPicker colorPicker, String value) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ColorPicker", colorPicker).attr("mode", colorPicker.getMode()).attr("color", value, null);
        this.encodeClientBehaviors(context, colorPicker);
        wb.finish();
    }
}

