/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.columntoggler;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.columntoggler.ColumnTogglerBase;
import org.primefaces.event.ToggleEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.model.Visibility;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class ColumnToggler
extends ColumnTogglerBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.ColumnToggler";
    private static final String DEFAULT_EVENT = "toggle";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("toggle", ToggleEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private UIComponent dataSourceComponent;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("jakarta.faces.behavior.event");
        if (event instanceof AjaxBehaviorEvent && DEFAULT_EVENT.equals(eventName)) {
            String clientId = this.getClientId(context);
            Visibility visibility = Visibility.valueOf((String)params.get(clientId + "_visibility"));
            int index = Integer.parseInt((String)params.get(clientId + "_index"));
            super.queueEvent((FacesEvent)new ToggleEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior(), visibility, index));
        } else {
            super.queueEvent(event);
        }
    }

    public UIComponent getDataSourceComponent() {
        if (this.dataSourceComponent == null) {
            this.dataSourceComponent = SearchExpressionFacade.resolveComponent(this.getFacesContext(), (UIComponent)this, this.getDatasource());
        }
        return this.dataSourceComponent;
    }

    public Object saveState(FacesContext context) {
        this.dataSourceComponent = null;
        return super.saveState(context);
    }
}

