/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandbutton;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.api.DialogReturnAware;
import org.primefaces.component.commandbutton.CommandButtonBase;
import org.primefaces.event.SelectEvent;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class CommandButton
extends CommandButtonBase
implements DialogReturnAware {
    public static final String COMPONENT_TYPE = "org.primefaces.component.CommandButton";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("click", null).put("dialogReturn", SelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private String confirmationScript;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "click";
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isDialogReturnEvent(event, context)) {
            this.queueDialogReturnEvent(event, context, (UIComponent)this, x$0 -> super.queueEvent(x$0));
        } else {
            super.queueEvent(event);
        }
    }

    public String resolveStyleClass() {
        String userStyleClass;
        String icon = this.getIcon();
        Object value = this.getValue();
        String styleClass = "";
        if (value != null && LangUtils.isValueBlank(icon)) {
            styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only";
        } else if (value != null && !LangUtils.isValueBlank(icon)) {
            styleClass = this.getIconPos().equals("left") ? "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left" : "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-right";
        } else if (value == null && !LangUtils.isValueBlank(icon)) {
            styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only";
        }
        if (this.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        if ((userStyleClass = this.getStyleClass()) != null) {
            styleClass = styleClass + " " + userStyleClass;
        }
        return styleClass;
    }

    @Override
    public boolean isPartialSubmitSet() {
        return this.getStateHelper().get((Serializable)((Object)CommandButtonBase.PropertyKeys.partialSubmit)) != null || this.getValueExpression(CommandButtonBase.PropertyKeys.partialSubmit.toString()) != null;
    }

    @Override
    public boolean isResetValuesSet() {
        return this.getStateHelper().get((Serializable)((Object)CommandButtonBase.PropertyKeys.resetValues)) != null || this.getValueExpression(CommandButtonBase.PropertyKeys.resetValues.toString()) != null;
    }

    @Override
    public String getConfirmationScript() {
        return this.confirmationScript;
    }

    @Override
    public void setConfirmationScript(String confirmationScript) {
        this.confirmationScript = confirmationScript;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.confirmationScript != null;
    }

    @Override
    public boolean isAjaxified() {
        return !this.getType().equals("reset") && !this.getType().equals("button") && this.isAjax();
    }
}

