/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dashboard;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.dashboard.DashboardBase;
import org.primefaces.event.DashboardReorderEvent;
import org.primefaces.model.DashboardColumn;
import org.primefaces.model.DashboardModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Dashboard
extends DashboardBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Dashboard";
    public static final String CONTAINER_CLASS = "ui-dashboard";
    public static final String COLUMN_CLASS = "ui-dashboard-column";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("reorder", DashboardReorderEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("reorder".equals(eventName)) {
                String[] idTokens;
                String widgetClientId = (String)params.get(clientId + "_widgetId");
                Integer itemIndex = Integer.valueOf((String)params.get(clientId + "_itemIndex"));
                Integer receiverColumnIndex = Integer.valueOf((String)params.get(clientId + "_receiverColumnIndex"));
                String senderIndexParam = clientId + "_senderColumnIndex";
                Integer senderColumnIndex = null;
                if (params.containsKey(senderIndexParam)) {
                    senderColumnIndex = Integer.valueOf((String)params.get(senderIndexParam));
                }
                String widgetId = (idTokens = widgetClientId.split(":")).length == 1 ? idTokens[0] : idTokens[idTokens.length - 1];
                DashboardReorderEvent reorderEvent = new DashboardReorderEvent((UIComponent)this, behaviorEvent.getBehavior(), widgetId, itemIndex, receiverColumnIndex, senderColumnIndex);
                reorderEvent.setPhaseId(behaviorEvent.getPhaseId());
                this.updateDashboardModel(this.getModel(), widgetId, itemIndex, receiverColumnIndex, senderColumnIndex);
                super.queueEvent((FacesEvent)reorderEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    protected void updateDashboardModel(DashboardModel model, String widgetId, Integer itemIndex, Integer receiverColumnIndex, Integer senderColumnIndex) {
        if (senderColumnIndex == null) {
            DashboardColumn column = model.getColumn(receiverColumnIndex);
            column.reorderWidget(itemIndex, widgetId);
        } else {
            DashboardColumn oldColumn = model.getColumn(senderColumnIndex);
            DashboardColumn newColumn = model.getColumn(receiverColumnIndex);
            model.transferWidget(oldColumn, newColumn, widgetId, itemIndex);
        }
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered() || this.isDisabled()) {
            return;
        }
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processUpdates(context);
        }
    }
}

