/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.context.FacesContext;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableExporter;
import org.primefaces.component.export.ExcelOptions;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.row.Row;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public class DataTableExcelExporter
extends DataTableExporter {
    protected static final String DEFAULT_FONT = "Arial";
    protected Workbook wb;
    private CellStyle cellStyleRightAlign;
    private CellStyle cellStyleCenterAlign;
    private CellStyle cellStyleLeftAlign;
    private CellStyle facetStyle;
    private boolean stronglyTypedCells;

    @Override
    protected void preExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
        this.wb = this.createWorkBook();
        if (exportConfiguration.getPreProcessor() != null) {
            exportConfiguration.getPreProcessor().invoke(context.getELContext(), new Object[]{this.wb});
        }
    }

    @Override
    public void doExport(FacesContext context, DataTable table, ExportConfiguration exportConfiguration, int index) throws IOException {
        ExcelOptions options;
        String sheetName = this.getSheetName(context, (UIComponent)table);
        if (sheetName == null) {
            sheetName = table.getId() + (index + 1);
        }
        if ("empty".equals(sheetName = WorkbookUtil.createSafeSheetName((String)sheetName)) || "null".equals(sheetName)) {
            sheetName = "Sheet (" + (index + 1) + ")";
        }
        this.stronglyTypedCells = (options = (ExcelOptions)exportConfiguration.getOptions()) == null ? true : options.isStronglyTypedCells();
        Sheet sheet = this.createSheet(this.wb, sheetName, options);
        this.applyOptions(this.wb, table, sheet, options);
        this.exportTable(context, (UIComponent)table, sheet, exportConfiguration);
        if (options == null || options.isAutoSizeColumn()) {
            int colIndex = 0;
            for (UIColumn col : table.getColumns()) {
                if (col instanceof DynamicColumn) {
                    ((DynamicColumn)col).applyStatelessModel();
                }
                if (!col.isRendered() || !col.isExportable()) continue;
                sheet.autoSizeColumn(colIndex);
                colIndex = (short)(colIndex + 1);
            }
        }
    }

    @Override
    protected void postExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
        if (exportConfiguration.getPostProcessor() != null) {
            exportConfiguration.getPostProcessor().invoke(context.getELContext(), new Object[]{this.wb});
        }
        this.wb.write(this.getOutputStream());
        this.wb.close();
        this.wb = null;
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        Sheet sheet = (Sheet)document;
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        org.apache.poi.ss.usermodel.Row row = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(table, row, col.getChildren(), col);
        }
    }

    protected void addColumnFacets(DataTable table, Sheet sheet, DataTableExporter.ColumnType columnType) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        org.apache.poi.ss.usermodel.Row rowHeader = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            UIComponent facet = col.getFacet(columnType.facet());
            switch (columnType) {
                case HEADER: {
                    textValue = col.getExportHeaderValue() != null ? col.getExportHeaderValue() : col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getExportFooterValue() != null ? col.getExportFooterValue() : col.getFooterText();
                    break;
                }
                default: {
                    textValue = null;
                }
            }
            if (textValue != null) {
                this.addColumnValue(rowHeader, textValue);
                continue;
            }
            if (ComponentUtils.shouldRenderFacet(facet)) {
                this.addColumnValue(rowHeader, facet);
                continue;
            }
            this.addColumnValue(rowHeader, "");
        }
    }

    protected void addTableFacets(FacesContext context, DataTable table, Sheet sheet, DataTableExporter.ColumnType columnType) {
        String facetText = null;
        UIComponent facet = table.getFacet(columnType.facet());
        if (ComponentUtils.shouldRenderFacet(facet)) {
            if (facet instanceof UIPanel) {
                for (UIComponent child : facet.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    facetText = value;
                    break;
                }
            } else {
                facetText = ComponentUtils.getValueToRender(context, facet);
            }
        }
        if (facetText != null) {
            int colspan = 0;
            for (UIColumn col : table.getColumns()) {
                if (!col.isRendered() || !col.isExportable()) continue;
                ++colspan;
            }
            int rowIndex = sheet.getLastRowNum() + 1;
            org.apache.poi.ss.usermodel.Row rowHeader = sheet.createRow(rowIndex);
            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, colspan - 1));
            this.addColumnValue(rowHeader, 0, facetText);
        }
    }

    protected void addColumnValue(org.apache.poi.ss.usermodel.Row row, UIComponent component) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(row, value);
    }

    protected void addColumnValue(org.apache.poi.ss.usermodel.Row row, String value) {
        short col = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        this.addColumnValue(row, col, value);
    }

    protected void addColumnValue(org.apache.poi.ss.usermodel.Row row, int col, String text) {
        Cell cell = row.createCell(col);
        cell.setCellValue(this.createRichTextString(text));
        cell.setCellStyle(this.facetStyle);
    }

    protected void addColumnValue(DataTable table, org.apache.poi.ss.usermodel.Row row, List<UIComponent> components, UIColumn column) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        FacesContext context = FacesContext.getCurrentInstance();
        this.applyColumnAlignments(column, cell);
        if (LangUtils.isNotBlank(column.getExportValue())) {
            this.updateCell(cell, column.getExportValue());
        } else if (column.getExportFunction() != null) {
            this.updateCell(cell, this.exportColumnByFunction(context, column));
        } else if (LangUtils.isNotBlank(column.getField())) {
            String value = table.getConvertedFieldValue(context, column);
            this.updateCell(cell, Objects.toString(value, ""));
        } else {
            StringBuilder builder = new StringBuilder();
            for (UIComponent component : components) {
                String value;
                if (!component.isRendered() || (value = this.exportValue(context, component)) == null) continue;
                builder.append(value);
            }
            this.updateCell(cell, builder.toString());
        }
    }

    protected boolean addColumnGroup(DataTable table, Sheet sheet, DataTableExporter.ColumnType columnType) {
        ColumnGroup cg = table.getColumnGroup(columnType.facet());
        if (cg == null || cg.getChildCount() == 0) {
            return false;
        }
        for (UIComponent component : cg.getChildren()) {
            if (!(component instanceof Row)) continue;
            Row row = (Row)component;
            int rowIndex = sheet.getLastRowNum() + 1;
            org.apache.poi.ss.usermodel.Row xlRow = sheet.createRow(rowIndex);
            int colIndex = 0;
            for (UIComponent rowComponent : row.getChildren()) {
                UIColumn column;
                if (!(rowComponent instanceof UIColumn) || !(column = (UIColumn)rowComponent).isRendered() || !column.isExportable()) continue;
                String text = null;
                switch (columnType) {
                    case HEADER: {
                        text = column.getExportHeaderValue() != null ? column.getExportHeaderValue() : column.getHeaderText();
                        break;
                    }
                    case FOOTER: {
                        text = column.getExportFooterValue() != null ? column.getExportFooterValue() : column.getFooterText();
                        break;
                    }
                    default: {
                        text = null;
                    }
                }
                int rowSpan = column.getRowspan() - 1;
                int colSpan = column.getColspan() - 1;
                if (rowSpan > 0 && colSpan > 0) {
                    colIndex = this.calculateColumnOffset(sheet, rowIndex, colIndex);
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex, colIndex + colSpan));
                    this.addColumnValue(xlRow, (short)colIndex, text);
                    colIndex += colSpan;
                } else if (rowSpan > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex, colIndex));
                    this.addColumnValue(xlRow, (short)colIndex, text);
                } else if (colSpan > 0) {
                    colIndex = this.calculateColumnOffset(sheet, rowIndex, colIndex);
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex, colIndex + colSpan));
                    this.addColumnValue(xlRow, (short)colIndex, text);
                    colIndex += colSpan;
                } else {
                    colIndex = this.calculateColumnOffset(sheet, rowIndex, colIndex);
                    this.addColumnValue(xlRow, (short)colIndex, text);
                }
                ++colIndex;
            }
        }
        return true;
    }

    protected int calculateColumnOffset(Sheet sheet, int row, int col) {
        for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
            CellRangeAddress merged = sheet.getMergedRegion(j);
            if (!merged.isInRange(row, col)) continue;
            col = merged.getLastColumn() + 1;
        }
        return col;
    }

    protected void updateCell(Cell cell, String value) {
        if (this.stronglyTypedCells && LangUtils.isNumeric(value)) {
            cell.setCellValue(Double.parseDouble(value));
        } else {
            cell.setCellValue(this.createRichTextString(value));
        }
    }

    protected RichTextString createRichTextString(String value) {
        return new HSSFRichTextString(value);
    }

    protected Workbook createWorkBook() {
        return new HSSFWorkbook();
    }

    protected Workbook getWorkBook() {
        return this.wb;
    }

    protected Sheet createSheet(Workbook wb, String sheetName, ExcelOptions options) {
        return wb.createSheet(sheetName);
    }

    @Override
    public String getContentType() {
        return "application/vnd.ms-excel";
    }

    @Override
    public String getFileExtension() {
        return ".xls";
    }

    public void exportTable(FacesContext context, UIComponent component, Sheet sheet, ExportConfiguration exportConfiguration) {
        DataTable table = (DataTable)component;
        this.addTableFacets(context, table, sheet, DataTableExporter.ColumnType.HEADER);
        boolean headerGroup = this.addColumnGroup(table, sheet, DataTableExporter.ColumnType.HEADER);
        if (!headerGroup) {
            this.addColumnFacets(table, sheet, DataTableExporter.ColumnType.HEADER);
        }
        if (exportConfiguration.isPageOnly()) {
            this.exportPageOnly(context, table, sheet);
        } else if (exportConfiguration.isSelectionOnly()) {
            this.exportSelectionOnly(context, table, sheet);
        } else {
            this.exportAll(context, table, sheet);
        }
        this.addColumnGroup(table, sheet, DataTableExporter.ColumnType.FOOTER);
        if (table.hasFooterColumn()) {
            this.addColumnFacets(table, sheet, DataTableExporter.ColumnType.FOOTER);
        }
        this.addTableFacets(context, table, sheet, DataTableExporter.ColumnType.FOOTER);
        table.setRowIndex(-1);
    }

    protected void applyOptions(Workbook wb, DataTable table, Sheet sheet, ExporterOptions options) {
        Font font = this.getFont(wb, options);
        this.facetStyle = wb.createCellStyle();
        this.facetStyle.setFont(font);
        this.facetStyle.setAlignment(HorizontalAlignment.CENTER);
        this.facetStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.facetStyle.setWrapText(true);
        this.applyFacetOptions(wb, options, this.facetStyle);
        this.cellStyleLeftAlign = wb.createCellStyle();
        this.cellStyleLeftAlign.setFont(font);
        this.cellStyleLeftAlign.setAlignment(HorizontalAlignment.LEFT);
        this.applyCellOptions(wb, options, this.cellStyleLeftAlign);
        this.cellStyleCenterAlign = wb.createCellStyle();
        this.cellStyleCenterAlign.setFont(font);
        this.cellStyleCenterAlign.setAlignment(HorizontalAlignment.CENTER);
        this.applyCellOptions(wb, options, this.cellStyleCenterAlign);
        this.cellStyleRightAlign = wb.createCellStyle();
        this.cellStyleRightAlign.setFont(font);
        this.cellStyleRightAlign.setAlignment(HorizontalAlignment.RIGHT);
        this.applyCellOptions(wb, options, this.cellStyleRightAlign);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        printSetup.setPaperSize((short)9);
        sheet.setPrintGridlines(true);
    }

    protected void applyFacetOptions(Workbook wb, ExporterOptions options, CellStyle facetStyle) {
        Font facetFont = this.getFont(wb, options);
        if (options != null) {
            String facetFontSize;
            String facetFontColor;
            String facetFontStyle = options.getFacetFontStyle();
            if (facetFontStyle != null) {
                if ("BOLD".equalsIgnoreCase(facetFontStyle)) {
                    facetFont.setBold(true);
                }
                if ("ITALIC".equalsIgnoreCase(facetFontStyle)) {
                    facetFont.setItalic(true);
                }
            }
            HSSFPalette palette = ((HSSFWorkbook)wb).getCustomPalette();
            Color color = null;
            String facetBackground = options.getFacetBgColor();
            if (facetBackground != null) {
                color = Color.decode(facetBackground);
                HSSFColor backgroundColor = palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue());
                facetStyle.setFillForegroundColor(backgroundColor.getIndex());
                facetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if ((facetFontColor = options.getFacetFontColor()) != null) {
                color = Color.decode(facetFontColor);
                HSSFColor facetColor = palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue());
                facetFont.setColor(facetColor.getIndex());
            }
            if ((facetFontSize = options.getFacetFontSize()) != null) {
                facetFont.setFontHeightInPoints(Short.valueOf(facetFontSize).shortValue());
            }
        }
        facetStyle.setFont(facetFont);
    }

    protected void applyCellOptions(Workbook wb, ExporterOptions options, CellStyle cellStyle) {
        Font cellFont = this.getFont(wb, options);
        if (options != null) {
            String cellFontStyle;
            String cellFontSize;
            String cellFontColor = options.getCellFontColor();
            if (cellFontColor != null) {
                HSSFPalette palette = ((HSSFWorkbook)wb).getCustomPalette();
                Color color = Color.decode(cellFontColor);
                HSSFColor cellColor = palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue());
                cellFont.setColor(cellColor.getIndex());
            }
            if ((cellFontSize = options.getCellFontSize()) != null) {
                cellFont.setFontHeightInPoints(Short.valueOf(cellFontSize).shortValue());
            }
            if ((cellFontStyle = options.getCellFontStyle()) != null) {
                if ("BOLD".equalsIgnoreCase(cellFontStyle)) {
                    cellFont.setBold(true);
                }
                if ("ITALIC".equalsIgnoreCase(cellFontStyle)) {
                    cellFont.setItalic(true);
                }
            }
        }
        cellStyle.setFont(cellFont);
    }

    protected Cell applyColumnAlignments(UIColumn column, Cell cell) {
        String[] styles = new String[]{column.getStyle(), column.getStyleClass()};
        if (LangUtils.containsIgnoreCase(styles, "right")) {
            cell.setCellStyle(this.cellStyleRightAlign);
        } else if (LangUtils.containsIgnoreCase(styles, "center")) {
            cell.setCellStyle(this.cellStyleCenterAlign);
        } else {
            cell.setCellStyle(this.cellStyleLeftAlign);
        }
        return cell;
    }

    public String getSheetName(FacesContext context, UIComponent table) {
        UIComponent header = table.getFacet("header");
        if (header != null) {
            if (header instanceof UIPanel) {
                for (UIComponent child : header.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    return value;
                }
            } else {
                return ComponentUtils.getValueToRender(context, header);
            }
        }
        return null;
    }

    public Font getFont(Workbook wb, ExporterOptions options) {
        Font font = wb.createFont();
        if (options != null) {
            String fontName = LangUtils.isValueBlank(options.getFontName()) ? DEFAULT_FONT : options.getFontName();
            font.setFontName(fontName);
        } else {
            font.setFontName(DEFAULT_FONT);
        }
        return font;
    }
}

