/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dialog;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.dialog.Dialog;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class DialogRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Dialog dialog = (Dialog)component;
        if (dialog.isContentLoadRequest(context)) {
            this.renderChildren(context, component);
        } else {
            this.encodeMarkup(context, dialog);
            this.encodeScript(context, dialog);
        }
    }

    protected void encodeScript(FacesContext context, Dialog dialog) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Dialog", dialog);
        wb.attr("visible", dialog.isVisible(), false).attr("draggable", dialog.isDraggable(), true).attr("resizable", dialog.isResizable(), true).attr("modal", dialog.isModal(), false).attr("blockScroll", dialog.isBlockScroll(), false).attr("width", dialog.getWidth(), null).attr("height", dialog.getHeight(), null).attr("minWidth", dialog.getMinWidth(), Integer.MIN_VALUE).attr("minHeight", dialog.getMinHeight(), Integer.MIN_VALUE).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)dialog, dialog.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null).attr("dynamic", dialog.isDynamic(), false).attr("showEffect", dialog.getShowEffect(), null).attr("hideEffect", dialog.getHideEffect(), null).attr("my", dialog.getMy(), null).attr("position", dialog.getPosition(), null).attr("closeOnEscape", dialog.isCloseOnEscape(), false).attr("fitViewport", dialog.isFitViewport(), false).attr("responsive", dialog.isResponsive(), false).attr("cache", dialog.isCache(), true).callback("onHide", "function()", dialog.getOnHide()).callback("onShow", "function()", dialog.getOnShow());
        String focusExpressions = SearchExpressionFacade.resolveClientIds(context, (UIComponent)dialog, dialog.getFocus(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE);
        if (focusExpressions != null) {
            wb.attr("focus", focusExpressions);
        }
        this.encodeClientBehaviors(context, dialog);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        String positionType = dialog.getPositionType();
        String style = dialog.getStyle();
        String styleClass = dialog.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-dialog ui-widget ui-widget-content ui-corner-all ui-shadow ui-hidden-container" : "ui-dialog ui-widget ui-widget-content ui-corner-all ui-shadow ui-hidden-container " + styleClass;
        if (ComponentUtils.isRTL(context, dialog)) {
            styleClass = styleClass + " ui-dialog-rtl";
        }
        if ("absolute".equals(positionType)) {
            styleClass = styleClass + " ui-dialog-absolute";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (dialog.isShowHeader()) {
            this.encodeHeader(context, dialog);
        }
        this.encodeContent(context, dialog);
        this.encodeFooter(context, dialog);
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String header = dialog.getHeader();
        UIComponent headerFacet = dialog.getFacet("header");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-titlebar ui-widget-header ui-helper-clearfix ui-corner-top", null);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(dialog.getClientId(context) + "_title"), null);
        writer.writeAttribute("class", (Object)"ui-dialog-title", null);
        if (ComponentUtils.shouldRenderFacet(headerFacet)) {
            headerFacet.encodeAll(context);
        } else if (header != null) {
            writer.writeText((Object)header, null);
        }
        writer.endElement("span");
        if (dialog.isClosable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-close ui-corner-all", "ui-icon ui-icon-closethick", MessageFactory.getMessage("primefaces.dialog.aria.CLOSE", new Object[0]));
        }
        if (dialog.isMaximizable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-maximize ui-corner-all", "ui-icon ui-icon-extlink", null);
        }
        if (dialog.isMinimizable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-minimize ui-corner-all", "ui-icon ui-icon-minus", null);
        }
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String footer = dialog.getFooter();
        UIComponent footerFacet = dialog.getFacet("footer");
        if (!(footer != null || footerFacet != null && footerFacet.isRendered())) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-footer ui-widget-content", null);
        writer.startElement("span", null);
        if (ComponentUtils.shouldRenderFacet(footerFacet)) {
            footerFacet.encodeAll(context);
        } else if (footer != null) {
            writer.writeText((Object)footer, null);
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-content ui-widget-content", null);
        writer.writeAttribute("id", (Object)(dialog.getClientId(context) + "_content"), null);
        if (!dialog.isDynamic()) {
            this.renderChildren(context, (UIComponent)dialog);
        }
        writer.endElement("div");
    }

    protected void encodeIcon(FacesContext context, String anchorClass, String iconClass, String ariaLabel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)anchorClass, null);
        if (ariaLabel != null) {
            writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("a");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

