/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dock;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.primefaces.component.dock.Dock;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DockRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeScript(FacesContext context, AbstractMenu menu) throws IOException {
        Dock dock = (Dock)menu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Dock", dock).attr("position", dock.getPosition()).attr("halign", dock.getHalign()).attr("blockScroll", dock.isBlockScroll(), false).attr("animate", dock.isAnimate()).attr("animationDuration", dock.getAnimationDuration());
        wb.finish();
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Dock dock = (Dock)menu;
        String clientId = dock.getClientId(context);
        String position = dock.getPosition();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)("ui-dock " + position + " ui-widget"), "styleClass");
        this.renderPassThruAttributes(context, (UIComponent)dock, new List[0]);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)("ui-dock-container " + dock.getHalign() + " " + position), null);
        writer.writeAttribute("role", (Object)"menu", null);
        this.encodeMenuItems(context, dock);
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuItems(FacesContext context, Dock dock) throws IOException {
        if (dock.getElementsCount() > 0) {
            ResponseWriter writer = context.getResponseWriter();
            ArrayList menuElements = new ArrayList(dock.getElements());
            if (ComponentUtils.isRTL(context, dock)) {
                Collections.reverse(menuElements);
            }
            for (MenuElement element : menuElements) {
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-dock-item", "styleClass");
                writer.writeAttribute("role", (Object)"none", null);
                this.encodeMenuItem(context, dock, (MenuItem)element, "-1");
                writer.endElement("li");
            }
        }
    }

    @Override
    protected void encodeMenuItemContent(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        this.encodeItemLabel(context, menuitem);
        this.encodeItemIcon(context, menuitem);
    }

    protected void encodeItemIcon(FacesContext context, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, menuitem.getIcon()), null);
        writer.writeAttribute("class", (Object)"ui-dock-image", "styleClass");
        writer.endElement("img");
    }

    protected void encodeItemLabel(FacesContext context, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("em", null);
        writer.startElement("span", null);
        if (menuitem.getValue() != null) {
            if (menuitem.isEscape()) {
                writer.writeText(menuitem.getValue(), "value");
            } else {
                writer.write((String)menuitem.getValue());
            }
        }
        writer.endElement("span");
        writer.endElement("em");
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }
}

