/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fieldset;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.fieldset.FieldsetBase;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Fieldset
extends FieldsetBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Fieldset";
    public static final String FIELDSET_CLASS = "ui-fieldset ui-widget ui-widget-content ui-corner-all ui-hidden-container";
    public static final String TOGGLEABLE_FIELDSET_CLASS = "ui-fieldset ui-widget ui-widget-content ui-corner-all ui-hidden-container ui-fieldset-toggleable";
    public static final String CONTENT_CLASS = "ui-fieldset-content";
    public static final String LEGEND_CLASS = "ui-fieldset-legend ui-corner-all ui-state-default";
    public static final String TOGGLER_MINUS_CLASS = "ui-fieldset-toggler ui-icon ui-icon-minusthick";
    public static final String TOGGLER_PLUS_CLASS = "ui-fieldset-toggler ui-icon ui-icon-plusthick";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("toggle", ToggleEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("toggle".equals(eventName)) {
                Visibility visibility = this.isCollapsed() ? Visibility.HIDDEN : Visibility.VISIBLE;
                super.queueEvent((FacesEvent)new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility));
            }
        } else {
            super.queueEvent(event);
        }
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public void processDecodes(FacesContext context) {
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processUpdates(context);
        }
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }
}

