/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import java.util.logging.Logger;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.component.fileupload.FileUploadDecoder;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class FileUploadRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(FileUploadRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        if (!context.getExternalContext().getRequestContentType().toLowerCase().startsWith("multipart/")) {
            if (!context.isProjectStage(ProjectStage.Production)) {
                LOGGER.fine("Decoding FileUpload requires contentType \"multipart/form-data\". Skipping... ClientId: " + component.getClientId(context));
            }
            return;
        }
        FileUpload fileUpload = (FileUpload)component;
        if (!fileUpload.isDisabled()) {
            PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
            FileUploadDecoder decoder = applicationContext.getFileUploadDecoder();
            decoder.decode(context, fileUpload);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        FileUpload fileUpload = (FileUpload)component;
        this.encodeMarkup(context, fileUpload);
        this.encodeScript(context, fileUpload);
    }

    protected void encodeScript(FacesContext context, FileUpload fileUpload) throws IOException {
        String update = fileUpload.getUpdate();
        String process = fileUpload.getProcess();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        if (fileUpload.getMode().equals("advanced")) {
            PrimeApplicationContext pfContext = PrimeApplicationContext.getCurrentInstance(context);
            wb.init("FileUpload", fileUpload);
            wb.attr("dnd", fileUpload.isDragDropSupport(), true).attr("previewWidth", fileUpload.getPreviewWidth(), 80).attr("sequentialUploads", fileUpload.isSequential(), false).attr("maxChunkSize", fileUpload.getMaxChunkSize().longValue(), 0.0).attr("maxRetries", fileUpload.getMaxRetries(), 30).attr("retryTimeout", fileUpload.getRetryTimeout(), 1000).attr("resumeContextPath", pfContext.getFileUploadResumeUrl(), null).callback("onAdd", "function(file, callback)", fileUpload.getOnAdd()).callback("oncancel", "function()", fileUpload.getOncancel());
        } else {
            wb.init("SimpleFileUpload", fileUpload).attr("skinSimple", fileUpload.isSkinSimple(), false);
        }
        wb.attr("auto", fileUpload.isAuto(), false).attr("update", SearchExpressionFacade.resolveClientIds(context, (UIComponent)fileUpload, update, SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null).attr("process", SearchExpressionFacade.resolveClientIds(context, (UIComponent)fileUpload, process, SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null).attr("global", fileUpload.isGlobal(), true).attr("disabled", fileUpload.isDisabled(), false).attr("invalidSizeMessage", fileUpload.getInvalidSizeMessage(), null).attr("invalidFileMessage", fileUpload.getInvalidFileMessage(), null).attr("fileLimitMessage", fileUpload.getFileLimitMessage(), null).attr("messageTemplate", fileUpload.getMessageTemplate(), null).attr("maxFileSize", fileUpload.getSizeLimit().longValue(), 9.223372036854776E18).attr("fileLimit", fileUpload.getFileLimit(), Integer.MAX_VALUE).callback("onupload", "function()", fileUpload.getOnupload()).callback("onstart", "function()", fileUpload.getOnstart()).callback("onerror", "function()", fileUpload.getOnerror()).callback("oncomplete", "function(args)", fileUpload.getOncomplete()).callback("onvalidationfailure", "function(msg)", fileUpload.getOnvalidationfailure());
        String allowTypes = fileUpload.getAllowTypes();
        if (allowTypes != null) {
            wb.append(",allowTypes:").append(allowTypes);
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        if (fileUpload.getMode().equals("simple")) {
            this.encodeSimpleMarkup(context, fileUpload);
        } else {
            this.encodeAdvancedMarkup(context, fileUpload);
        }
    }

    protected void encodeAdvancedMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String style = fileUpload.getStyle();
        String styleClass = fileUpload.getStyleClass();
        styleClass = styleClass == null ? "ui-fileupload ui-widget ui-fileupload-responsive" : "ui-fileupload ui-widget ui-fileupload-responsive " + styleClass;
        boolean disabled = fileUpload.isDisabled();
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, styleClass);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("class", (Object)"ui-fileupload-buttonbar ui-widget-header ui-corner-top", null);
        this.encodeChooseButton(context, fileUpload, disabled);
        if (!fileUpload.isAuto()) {
            this.encodeButton(context, fileUpload.getUploadLabel(), "ui-fileupload-upload", " " + fileUpload.getUploadIcon(), fileUpload.getUploadButtonTitle());
            this.encodeButton(context, fileUpload.getCancelLabel(), "ui-fileupload-cancel", " " + fileUpload.getCancelIcon(), fileUpload.getCancelButtonTitle());
        }
        writer.endElement("div");
        this.renderChildren(context, (UIComponent)fileUpload);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-fileupload-content ui-widget-content ui-corner-bottom", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-fileupload-files", null);
        writer.startElement("div", null);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSimpleMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String style = fileUpload.getStyle();
        String styleClass = fileUpload.getStyleClass();
        String label = fileUpload.getLabel();
        if (fileUpload.isSkinSimple()) {
            styleClass = styleClass == null ? "ui-fileupload-simple ui-widget" : "ui-fileupload-simple ui-widget " + styleClass;
            styleClass = this.isValueBlank(label) ? "ui-fileupload-icon-only " + styleClass : styleClass;
            String buttonClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left";
            if (fileUpload.isDisabled()) {
                buttonClass = buttonClass + " ui-state-disabled";
            }
            writer.startElement("span", (UIComponent)fileUpload);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)buttonClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + fileUpload.getChooseIcon()), null);
            writer.endElement("span");
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_label"), null);
            writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
            if (this.isValueBlank(label)) {
                writer.write("&nbsp;");
            } else {
                writer.writeText((Object)label, "value");
            }
            writer.endElement("span");
            this.encodeInputField(context, fileUpload, clientId);
            writer.endElement("span");
            writer.startElement("span", (UIComponent)fileUpload);
            writer.writeAttribute("class", (Object)"ui-fileupload-filename", null);
            writer.endElement("span");
            writer.endElement("span");
        } else {
            this.encodeSimpleInputField(context, fileUpload, clientId, style, styleClass);
        }
    }

    protected void encodeChooseButton(FacesContext context, FileUpload fileUpload, boolean disabled) throws IOException {
        String tabindex;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String label = fileUpload.getLabel();
        String cssClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left ui-fileupload-choose";
        cssClass = this.isValueBlank(label) ? "ui-fileupload-icon-only " + cssClass : cssClass;
        String string = tabindex = disabled ? "-1" : "0";
        if (disabled) {
            cssClass = cssClass + " ui-state-disabled";
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)cssClass, null);
        writer.writeAttribute("tabindex", (Object)tabindex, null);
        writer.writeAttribute("role", (Object)"button", null);
        writer.writeAttribute("aria-labelledby", (Object)(clientId + "_label"), null);
        String chooseButtonTitle = fileUpload.getChooseButtonTitle();
        if (chooseButtonTitle != null) {
            writer.writeAttribute("title", (Object)chooseButtonTitle, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + fileUpload.getChooseIcon()), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_label"), null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (this.isValueBlank(label)) {
            writer.write("&nbsp;");
        } else {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("span");
        if (!disabled) {
            this.encodeInputField(context, fileUpload, clientId);
        }
        writer.endElement("span");
    }

    protected void encodeInputField(FacesContext context, FileUpload fileUpload, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        if (fileUpload.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (fileUpload.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (fileUpload.getAccept() != null) {
            writer.writeAttribute("accept", (Object)fileUpload.getAccept(), null);
        }
        if (fileUpload.getTitle() != null) {
            writer.writeAttribute("title", (Object)fileUpload.getTitle(), null);
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)fileUpload);
        writer.endElement("input");
    }

    protected void encodeSimpleInputField(FacesContext context, FileUpload fileUpload, String clientId, String style, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        if (fileUpload.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (fileUpload.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (fileUpload.getAccept() != null) {
            writer.writeAttribute("accept", (Object)fileUpload.getAccept(), null);
        }
        if (fileUpload.getTitle() != null) {
            writer.writeAttribute("title", (Object)fileUpload.getTitle(), null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)fileUpload);
        writer.endElement("input");
    }

    protected void encodeButton(FacesContext context, String label, String styleClass, String icon, String title) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String cssClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left ui-state-disabled " + styleClass;
        cssClass = this.isValueBlank(label) ? "ui-fileupload-icon-only " + cssClass : cssClass;
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)cssClass, null);
        writer.writeAttribute("disabled", (Object)"disabled", null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        String iconClass = "ui-button-icon-left ui-icon ui-c";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(iconClass + " " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (this.isValueBlank(label)) {
            writer.write("&nbsp;");
        } else {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        FileUpload fileUpload = (FileUpload)component;
        if (fileUpload.getMode().equals("simple") && submittedValue != null && submittedValue.equals("")) {
            return null;
        }
        return submittedValue;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

