/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputtextarea;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.primefaces.component.inputtextarea.InputTextarea;
import org.primefaces.event.AutoCompleteEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class InputTextareaRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputTextarea inputTextarea = (InputTextarea)component;
        if (!this.shouldDecode((UIInput)inputTextarea)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputTextarea);
        String clientId = inputTextarea.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)params.get(clientId);
        if (submittedValue != null) {
            submittedValue = submittedValue.replaceAll("\\r\\n?", "\n");
            int maxlength = inputTextarea.getMaxlength();
            if (submittedValue.length() > maxlength) {
                submittedValue = LangUtils.substring(submittedValue, 0, maxlength);
            }
        }
        inputTextarea.setSubmittedValue(submittedValue);
        String query = (String)params.get(clientId + "_query");
        if (query != null) {
            AutoCompleteEvent autoCompleteEvent = new AutoCompleteEvent((UIComponent)inputTextarea, query);
            autoCompleteEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            inputTextarea.queueEvent(autoCompleteEvent);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputTextarea inputTextarea = (InputTextarea)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String query = (String)params.get(inputTextarea.getClientId(context) + "_query");
        if (query != null) {
            this.encodeSuggestions(context, inputTextarea, query);
        } else {
            this.encodeMarkup(context, inputTextarea);
            this.encodeScript(context, inputTextarea);
        }
    }

    public void encodeSuggestions(FacesContext context, InputTextarea inputTextarea, String query) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List items = inputTextarea.getSuggestions();
        writer.startElement("ul", (UIComponent)inputTextarea);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-list ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        for (Object item : items) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-list-item ui-corner-all", null);
            writer.writeAttribute("data-item-value", (Object)item.toString(), null);
            writer.writeText(item, null);
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    protected void encodeScript(FacesContext context, InputTextarea inputTextarea) throws IOException {
        boolean autoResize = inputTextarea.isAutoResize();
        String counter = inputTextarea.getCounter();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputTextarea", inputTextarea).attr("autoResize", autoResize).attr("maxlength", inputTextarea.getMaxlength(), Integer.MAX_VALUE);
        if (counter != null) {
            UIComponent counterComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)inputTextarea, counter);
            wb.attr("counter", counterComponent.getClientId(context)).attr("counterTemplate", inputTextarea.getCounterTemplate(), null);
        }
        if (inputTextarea.getCompleteMethod() != null) {
            wb.attr("autoComplete", true).attr("minQueryLength", inputTextarea.getMinQueryLength()).attr("queryDelay", inputTextarea.getQueryDelay()).attr("scrollHeight", inputTextarea.getScrollHeight(), Integer.MAX_VALUE);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputTextarea);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (inputTextarea.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputTextarea.getStyle(), null);
        }
        writer.writeAttribute("class", (Object)this.createStyleClass(inputTextarea), "styleClass");
        this.renderAccessibilityAttributes(context, (UIInput)inputTextarea);
        this.renderRTLDirection(context, inputTextarea);
        this.renderPassThruAttributes(context, (UIComponent)inputTextarea, HTML.TEXTAREA_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputTextarea, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputTextarea);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputTextarea);
        if (valueToRender != null) {
            if (inputTextarea.isAddLine()) {
                writer.writeText((Object)"\n", null);
            }
            writer.writeText((Object)valueToRender, "value");
        }
        writer.endElement("textarea");
    }

    protected String createStyleClass(InputTextarea inputTextarea) {
        String styleClass = this.createStyleClass((UIInput)inputTextarea, "ui-inputfield ui-inputtextarea ui-widget ui-state-default ui-corner-all");
        if (inputTextarea.isAutoResize()) {
            styleClass = styleClass + " ui-inputtextarea-resizable";
        }
        return styleClass;
    }
}

