/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.linkbutton;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.linkbutton.LinkButton;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class LinkButtonRenderer
extends OutcomeTargetRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        LinkButton linkButton = (LinkButton)component;
        this.encodeMarkup(context, linkButton);
        this.encodeScript(context, linkButton);
    }

    protected void encodeMarkup(FacesContext context, LinkButton linkButton) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean disabled = linkButton.isDisabled();
        boolean hasIcon = LangUtils.isNotBlank(linkButton.getIcon());
        boolean hasValue = LangUtils.isNotBlank((String)linkButton.getValue()) || linkButton.hasDisplayedChildren();
        boolean isTextAndIcon = hasValue && hasIcon;
        String style = linkButton.getStyle();
        String title = linkButton.getTitle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-linkbutton").add(linkButton.getStyleClass()).add(hasValue && !hasIcon, "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only").add(!hasValue && hasIcon, "ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only").add(isTextAndIcon && "left".equals(linkButton.getIconPos()), "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left", "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-right").add(disabled, "ui-state-disabled").build();
        writer.startElement("span", (UIComponent)linkButton);
        writer.writeAttribute("id", (Object)linkButton.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        this.renderPassThruAttributes(context, (UIComponent)linkButton, HTML.OUTPUT_EVENTS_WITHOUT_CLICK);
        if (disabled) {
            this.renderContent(context, linkButton);
        } else {
            String targetURL = this.getTargetURL(context, linkButton);
            if (targetURL == null) {
                targetURL = "#";
            }
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)targetURL, null);
            this.renderPassThruAttributes(context, (UIComponent)linkButton, HTML.LINK_ATTRS_WITHOUT_EVENTS_AND_STYLE, HTML.TITLE);
            this.renderDomEvents(context, (UIComponent)linkButton, HTML.OUTPUT_EVENTS);
            this.renderContent(context, linkButton);
            writer.endElement("a");
        }
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, LinkButton button) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("LinkButton", button);
        wb.finish();
    }

    protected void renderContent(FacesContext context, LinkButton linkButton) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = linkButton.getIcon();
        if (!this.isValueBlank(icon)) {
            String defaultIconClass = linkButton.getIconPos().equals("left") ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        String value = (String)linkButton.getValue();
        if (value == null) {
            if (linkButton.hasDisplayedChildren()) {
                this.renderChildren(context, (UIComponent)linkButton);
            } else {
                writer.write("ui-button");
            }
        } else if (linkButton.isEscape()) {
            writer.writeText((Object)value, "value");
        } else {
            writer.write(value);
        }
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

