/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubutton;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menubutton.MenuButton;
import org.primefaces.component.tieredmenu.TieredMenuRenderer;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class MenuButtonRenderer
extends TieredMenuRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-menubutton ui-widget" : "ui-menubutton ui-widget " + styleClass;
        boolean disabled = button.isDisabled();
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "class");
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "style");
        }
        if (button.getTitle() != null) {
            writer.writeAttribute("title", (Object)button.getTitle(), "title");
        }
        this.encodeButton(context, button, clientId + "_button", disabled);
        if (!disabled) {
            this.encodeMenu(context, button, clientId + "_menu");
        }
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, MenuButton button, String buttonId, boolean disabled) throws IOException {
        String buttonTextClass;
        ResponseWriter writer = context.getResponseWriter();
        boolean isIconLeft = button.getIconPos().equals("left");
        String value = button.getValue();
        String string = buttonTextClass = isIconLeft ? "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left" : "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-right";
        if (this.isValueBlank(value)) {
            buttonTextClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only";
        }
        String buttonClass = disabled ? buttonTextClass + " ui-state-disabled" : buttonTextClass;
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)buttonClass, null);
        writer.writeAttribute("aria-label", (Object)button.getAriaLabel(), "ariaLabel");
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        String iconClass = this.isValueBlank(button.getIcon()) ? "ui-icon-triangle-1-s" : button.getIcon();
        String iconPosClass = isIconLeft ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
        iconClass = iconPosClass + " " + iconClass;
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (this.isValueBlank(value)) {
            writer.write("ui-button");
        } else {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMenu(FacesContext context, MenuButton button, String menuId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String menuStyleClass = button.getMenuStyleClass();
        menuStyleClass = menuStyleClass == null ? "ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow" : "ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow " + menuStyleClass;
        writer.startElement("div", null);
        if (!LangUtils.isValueEmpty(button.getMaxHeight())) {
            menuStyleClass = menuStyleClass + " " + "ui-menu-dynamic-maxheight";
            char lastChar = button.getMaxHeight().charAt(button.getMaxHeight().length() - 1);
            String style = Character.isDigit(lastChar) ? button.getMaxHeight() + "px" : button.getMaxHeight();
            writer.writeAttribute("style", (Object)("max-height:" + style), null);
        }
        writer.writeAttribute("id", (Object)menuId, null);
        writer.writeAttribute("class", (Object)menuStyleClass, "styleClass");
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", "styleClass");
        if (button.getElementsCount() > 0) {
            List elements = button.getElements();
            this.encodeElements(context, button, elements);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        UIForm form = ComponentTraversalUtils.closestForm(context, (UIComponent)button);
        if (form == null) {
            throw new FacesException("MenuButton : \"" + clientId + "\" must be inside a form element");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("MenuButton", button);
        wb.attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)button, button.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null);
        wb.attr("collision", button.getCollision());
        wb.attr("autoDisplay", button.isAutoDisplay());
        wb.attr("toggleEvent", button.getToggleEvent(), null);
        wb.attr("delay", button.getDelay());
        wb.finish();
    }
}

