/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.multiselectlistbox;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.multiselectlistbox.MultiSelectListbox;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class MultiSelectListboxRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "jakarta.faces.SelectOne", "jakarta.faces.Listbox");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MultiSelectListbox listbox = (MultiSelectListbox)component;
        this.encodeMarkup(context, listbox);
        this.encodeScript(context, listbox);
    }

    protected void encodeMarkup(FacesContext context, MultiSelectListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = listbox.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)listbox);
        String style = listbox.getStyle();
        String styleClass = this.createStyleClass((UIInput)listbox, "ui-multiselectlistbox ui-widget ui-helper-clearfix");
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, listbox);
        this.encodeLists(context, listbox, selectItems);
        writer.endElement("div");
    }

    protected void encodeLists(FacesContext context, MultiSelectListbox listbox, List<SelectItem> itemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        SelectItem[] items = itemList == null ? null : itemList.toArray(new SelectItem[itemList.size()]);
        String header = listbox.getHeader();
        String listStyleClass = "ui-multiselectlistbox-list ui-inputfield ui-widget-content";
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)"ui-multiselectlistbox-listcontainer", null);
        if (header != null) {
            listStyleClass = listStyleClass + " ui-corner-bottom";
            writer.startElement("div", (UIComponent)listbox);
            writer.writeAttribute("class", (Object)"ui-multiselectlistbox-header ui-widget-header ui-corner-top", null);
            writer.writeText((Object)header, null);
            writer.endElement("div");
        } else {
            listStyleClass = listStyleClass + " ui-corner-all";
        }
        writer.startElement("ul", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)listStyleClass, null);
        this.renderARIARequired(context, (UIInput)listbox);
        if (items != null) {
            this.encodeListItems(context, listbox, items);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeListItems(FacesContext context, MultiSelectListbox listbox, SelectItem[] selectItems) throws IOException {
        if (selectItems != null && selectItems.length > 0) {
            ResponseWriter writer = context.getResponseWriter();
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)listbox);
            String itemValue = null;
            for (int i = 0; i < selectItems.length; ++i) {
                SelectItemGroup group;
                SelectItem[] groupItems;
                SelectItem selectItem = selectItems[i];
                itemValue = converter != null ? converter.getAsString(context, (UIComponent)listbox, selectItem.getValue()) : String.valueOf(selectItem.getValue());
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-multiselectlistbox-item", null);
                writer.writeAttribute("data-value", (Object)itemValue, null);
                writer.startElement("span", (UIComponent)listbox);
                writer.writeText((Object)selectItem.getLabel(), null);
                writer.endElement("span");
                if (selectItem instanceof SelectItemGroup && (groupItems = (group = (SelectItemGroup)selectItem).getSelectItems()) != null && groupItems.length > 0) {
                    this.encodeGroupItems(context, listbox, group.getSelectItems());
                }
                writer.endElement("li");
            }
        }
    }

    protected void encodeGroupItems(FacesContext context, MultiSelectListbox listbox, SelectItem[] selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        this.encodeListItems(context, listbox, selectItems);
        writer.endElement("ul");
    }

    protected void encodeScript(FacesContext context, MultiSelectListbox listbox) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("MultiSelectListbox", listbox).attr("effect", listbox.getEffect(), null).attr("showHeaders", listbox.isShowHeaders(), false);
        this.encodeClientBehaviors(context, listbox);
        wb.finish();
    }

    protected void encodeInput(FacesContext context, MultiSelectListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = listbox.getClientId(context) + "_input";
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)listbox);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)listbox);
        writer.endElement("input");
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }
}

