/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputpanel;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.outputpanel.OutputPanel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class OutputPanelRenderer
extends CoreRenderer {
    private static final String BLOCK = "div";
    private static final String INLINE = "span";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OutputPanel panel = (OutputPanel)component;
        if (panel.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)panel);
        } else {
            this.encodeMarkup(context, panel);
            if (this.isDeferredNecessary(context, panel)) {
                this.encodeScript(context, panel);
            }
        }
    }

    public void encodeMarkup(FacesContext context, OutputPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String tag = panel.getLayout().equals("block") ? BLOCK : INLINE;
        String clientId = panel.getClientId(context);
        String style = panel.getStyle();
        String styleClass = panel.getStyleClass();
        styleClass = styleClass == null ? "ui-outputpanel ui-widget" : "ui-outputpanel ui-widget " + styleClass;
        writer.startElement(tag, (UIComponent)panel);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        if (this.isDeferredNecessary(context, panel)) {
            this.renderLoading(context, panel);
        } else {
            this.renderChildren(context, (UIComponent)panel);
        }
        writer.endElement(tag);
    }

    protected void encodeScript(FacesContext context, OutputPanel panel) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("OutputPanel", panel);
        wb.attr("deferred", true).attr("deferredMode", panel.getDeferredMode());
        this.encodeClientBehaviors(context, panel);
        wb.finish();
    }

    protected void renderLoading(FacesContext context, OutputPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(BLOCK, null);
        writer.writeAttribute("class", (Object)"ui-outputpanel-loading ui-widget", null);
        writer.endElement(BLOCK);
    }

    protected boolean isDeferredNecessary(FacesContext context, OutputPanel panel) {
        return !context.getPartialViewContext().isAjaxRequest() && panel.isDeferred();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

