/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.ribbon;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.ribbon.Ribbon;
import org.primefaces.component.ribbon.RibbonGroup;
import org.primefaces.component.tabview.Tab;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class RibbonRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Ribbon ribbon = (Ribbon)component;
        this.encodeMarkup(context, ribbon);
        this.encodeScript(context, ribbon);
    }

    private void encodeScript(FacesContext context, Ribbon ribbon) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Ribbon", ribbon);
        this.encodeClientBehaviors(context, ribbon);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Ribbon ribbon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ribbon.getClientId(context);
        String style = ribbon.getStyle();
        String styleClass = ribbon.getStyleClass();
        styleClass = styleClass == null ? "ui-ribbon ui-tabs ui-tabs-top ui-widget ui-widget-content ui-corner-top ui-hidden-container" : "ui-ribbon ui-tabs ui-tabs-top ui-widget ui-widget-content ui-corner-top ui-hidden-container " + styleClass;
        writer.startElement("div", (UIComponent)ribbon);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("class", (Object)style, "style");
        }
        this.encodeTabHeaders(context, ribbon);
        this.encodeTabContents(context, ribbon);
        writer.endElement("div");
    }

    protected void encodeTabHeaders(FacesContext context, Ribbon ribbon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int activeIndex = ribbon.getActiveIndex();
        int childCount = ribbon.getChildCount();
        writer.startElement("ul", (UIComponent)ribbon);
        writer.writeAttribute("class", (Object)"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all", null);
        writer.writeAttribute("role", (Object)"tablist", null);
        if (childCount > 0) {
            List children = ribbon.getChildren();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (!(child instanceof Tab) || !child.isRendered()) continue;
                Tab tab = (Tab)child;
                String title = tab.getTitle();
                boolean active = i == activeIndex;
                String headerClass = active ? "ui-state-default ui-tabs-selected ui-tabs-header ui-state-active ui-corner-top" : "ui-state-default ui-corner-top ui-tabs-header";
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)headerClass, null);
                writer.writeAttribute("role", (Object)"tab", null);
                writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
                writer.startElement("a", null);
                writer.writeAttribute("href", (Object)tab.getClientId(context), null);
                if (title != null) {
                    writer.writeText((Object)title, null);
                }
                writer.endElement("a");
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
    }

    protected void encodeTabContents(FacesContext context, Ribbon ribbon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int activeIndex = ribbon.getActiveIndex();
        int childCount = ribbon.getChildCount();
        writer.startElement("div", (UIComponent)ribbon);
        writer.writeAttribute("class", (Object)"ui-tabs-panels", null);
        if (childCount > 0) {
            List children = ribbon.getChildren();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (!(child instanceof Tab) || !child.isRendered()) continue;
                Tab tab = (Tab)child;
                this.encodeTabContent(context, ribbon, tab, i == activeIndex);
            }
        }
        writer.endElement("div");
    }

    protected void encodeTabContent(FacesContext context, Ribbon ribbon, Tab tab, boolean active) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String contentClass = active ? "ui-tabs-panel ui-widget-content ui-corner-bottom" : "ui-tabs-panel ui-widget-content ui-corner-bottom ui-helper-hidden";
        int childCount = tab.getChildCount();
        writer.startElement("div", (UIComponent)ribbon);
        writer.writeAttribute("id", (Object)tab.getClientId(context), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        if (childCount > 0) {
            writer.startElement("ul", (UIComponent)ribbon);
            writer.writeAttribute("class", (Object)"ui-ribbon-groups ui-helper-reset ui-helper-clearfix ui-widget-content", null);
            List children = tab.getChildren();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (!(child instanceof RibbonGroup) || !child.isRendered()) continue;
                RibbonGroup group = (RibbonGroup)child;
                group.encodeAll(context);
            }
            writer.endElement("ul");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

