/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectbooleancheckbox;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import org.primefaces.component.selectbooleancheckbox.SelectBooleanCheckbox;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class SelectBooleanCheckboxRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        SelectBooleanCheckbox checkbox = (SelectBooleanCheckbox)component;
        if (!this.shouldDecode((UIInput)checkbox)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)checkbox);
        String clientId = checkbox.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        boolean checked = this.isChecked(submittedValue);
        checkbox.setSubmittedValue(checked);
    }

    protected boolean isChecked(String value) {
        return value != null && ("on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value));
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectBooleanCheckbox checkbox = (SelectBooleanCheckbox)component;
        this.encodeMarkup(context, checkbox);
        this.encodeScript(context, checkbox);
    }

    protected void encodeMarkup(FacesContext context, SelectBooleanCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        boolean checked = Boolean.parseBoolean(ComponentUtils.getValueToRender(context, (UIComponent)checkbox));
        boolean disabled = checkbox.isDisabled();
        String title = checkbox.getTitle();
        String style = checkbox.getStyle();
        String styleClass = checkbox.getStyleClass();
        styleClass = styleClass == null ? "ui-chkbox ui-widget" : "ui-chkbox ui-widget " + styleClass;
        styleClass = "ui-selectbooleancheckbox " + styleClass;
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        this.encodeInput(context, checkbox, clientId, checked);
        this.encodeOutput(context, checkbox, checked, disabled);
        this.encodeItemLabel(context, checkbox, clientId, disabled);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, SelectBooleanCheckbox checkbox, String clientId, boolean checked) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String ariaLabel = checkbox.getAriaLabel() != null ? checkbox.getAriaLabel() : checkbox.getItemLabel();
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
            writer.writeAttribute("aria-checked", (Object)"true", null);
        } else {
            writer.writeAttribute("aria-checked", (Object)"false", null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)checkbox);
        this.renderAccessibilityAttributes(context, (UIInput)checkbox);
        this.renderPassThruAttributes(context, (UIComponent)checkbox, HTML.TAB_INDEX);
        this.renderOnchange(context, (UIComponent)checkbox);
        this.renderDomEvents(context, (UIComponent)checkbox, HTML.BLUR_FOCUS_EVENTS);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOutput(FacesContext context, SelectBooleanCheckbox checkbox, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.createStyleClass((UIInput)checkbox, null, "ui-chkbox-box ui-widget ui-corner-all ui-state-default");
        styleClass = checked ? styleClass + " ui-state-active" : styleClass;
        styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
        String iconClass = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeItemLabel(FacesContext context, SelectBooleanCheckbox checkbox, String clientId, boolean disabled) throws IOException {
        String label = checkbox.getItemLabel();
        if (label != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            String styleClass = "ui-chkbox-label";
            styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
            writer.writeAttribute("class", (Object)styleClass, null);
            if (checkbox.isEscape()) {
                writer.writeText((Object)label, "itemLabel");
            } else {
                writer.write(label);
            }
            writer.endElement("span");
        }
    }

    protected void encodeScript(FacesContext context, SelectBooleanCheckbox checkbox) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectBooleanCheckbox", checkbox).finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return submittedValue instanceof Boolean ? submittedValue : Boolean.valueOf(submittedValue.toString());
    }

    @Override
    public String getHighlighter() {
        return "booleanchkbox";
    }
}

