/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectonebutton;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.selectonebutton.SelectOneButton;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class SelectOneButtonRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "jakarta.faces.SelectOne", "jakarta.faces.Radio");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneButton button = (SelectOneButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SelectOneButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)button);
        int selectItemsSize = selectItems.size();
        String style = button.getStyle();
        String styleClass = this.createStyleClass((UIInput)button, "ui-selectonebutton ui-buttonset ui-widget ui-corner-all");
        styleClass = styleClass + " ui-buttonset-" + selectItemsSize;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, button, selectItems);
        writer.endElement("div");
    }

    protected void encodeSelectItems(FacesContext context, SelectOneButton button, List<SelectItem> selectItems) throws IOException {
        int selectItemsSize = selectItems.size();
        Converter converter = button.getConverter();
        String name = button.getClientId(context);
        Object value = button.getSubmittedValue();
        if (value == null) {
            value = button.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        for (int i = 0; i < selectItems.size(); ++i) {
            Object coercedItemValue;
            SelectItem selectItem = selectItems.get(i);
            boolean disabled = selectItem.isDisabled() || button.isDisabled();
            String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + i;
            boolean selected = value == null && selectItem.getValue() == null ? true : (coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type)) != null && coercedItemValue.equals(value);
            this.encodeOption(context, button, selectItem, id, name, converter, selected, disabled, i, selectItemsSize);
        }
    }

    protected void encodeOption(FacesContext context, SelectOneButton button, SelectItem option, String id, String name, Converter converter, boolean selected, boolean disabled, int idx, int size) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)button, converter, option.getValue());
        String buttonStyle = "ui-button ui-widget ui-state-default ui-button-text-only";
        if (size == 1) {
            buttonStyle = buttonStyle + " ui-corner-all";
        } else if (idx == 0) {
            buttonStyle = buttonStyle + " ui-corner-left";
        } else if (idx == size - 1) {
            buttonStyle = buttonStyle + " ui-corner-right";
        }
        buttonStyle = selected ? buttonStyle + " ui-state-active" : buttonStyle;
        buttonStyle = disabled ? buttonStyle + " ui-state-disabled" : buttonStyle;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)buttonStyle, null);
        writer.writeAttribute("tabindex", (Object)button.getTabindex(), null);
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeAttribute("aria-label", (Object)option.getLabel(), null);
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)button);
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), "itemLabel");
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectOneButton button) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectOneButton", button).attr("unselectable", button.isUnselectable(), true).callback("change", "function()", button.getOnchange());
        this.encodeClientBehaviors(context, button);
        wb.finish();
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context);
    }
}

