/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.sidebar;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.sidebar.Sidebar;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SidebarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Sidebar bar = (Sidebar)component;
        if (bar.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)bar);
        } else {
            this.encodeMarkup(context, bar);
            this.encodeScript(context, bar);
        }
    }

    protected void encodeMarkup(FacesContext context, Sidebar bar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = bar.getStyle();
        String styleClass = bar.getStyleClass();
        styleClass = styleClass == null ? "ui-sidebar ui-widget ui-widget-content ui-shadow" : "ui-sidebar ui-widget ui-widget-content ui-shadow " + styleClass;
        styleClass = bar.isFullScreen() ? styleClass + " " + "ui-sidebar-full" : styleClass;
        styleClass = styleClass + " ui-sidebar-" + bar.getPosition();
        writer.startElement("div", (UIComponent)bar);
        writer.writeAttribute("id", (Object)bar.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (bar.isShowCloseIcon()) {
            this.encodeCloseIcon(context);
        }
        if (!bar.isDynamic()) {
            this.renderChildren(context, (UIComponent)bar);
        }
        writer.endElement("div");
    }

    protected void encodeCloseIcon(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-sidebar-close ui-corner-all", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-closethick", null);
        writer.endElement("span");
        writer.endElement("a");
    }

    private void encodeScript(FacesContext context, Sidebar bar) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Sidebar", bar).attr("visible", bar.isVisible(), false).attr("modal", bar.isModal(), true).attr("blockScroll", bar.isBlockScroll(), false).attr("baseZIndex", bar.getBaseZIndex(), 0).attr("dynamic", bar.isDynamic(), false).attr("showCloseIcon", bar.isShowCloseIcon(), true).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)bar, bar.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null).callback("onHide", "function()", bar.getOnHide()).callback("onShow", "function()", bar.getOnShow());
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

