/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import jakarta.el.ELContext;
import jakarta.faces.FacesException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.row.Row;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableState;
import org.primefaces.model.CheckboxTreeNode;
import org.primefaces.model.ColumnMeta;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeComparator;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.TreeUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.visit.ResetInputVisitCallback;

public class TreeTableRenderer
extends DataRenderer {
    private static final Logger LOGGER = Logger.getLogger(TreeTableRenderer.class.getName());
    private static final String SB_DECODE_SELECTION = TreeTableRenderer.class.getName() + "#decodeSelection";

    public void decode(FacesContext context, UIComponent component) {
        TreeTable tt = (TreeTable)component;
        if (tt.getSelectionMode() != null) {
            TreeNode root = tt.getValue();
            this.decodeSelection(context, tt, root);
        }
        if (tt.isSortRequest(context)) {
            this.decodeSort(context, tt);
        }
        tt.decodeColumnResizeState(context);
        this.decodeBehaviors(context, component);
    }

    protected void decodeSelection(FacesContext context, TreeTable tt, TreeNode root) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String selectionMode = tt.getSelectionMode();
        String clientId = tt.getClientId(context);
        if (selectionMode != null) {
            String selectionValue = (String)params.get(tt.getClientId(context) + "_selection");
            boolean isSingle = "single".equalsIgnoreCase(selectionMode);
            if (this.isValueBlank(selectionValue)) {
                if (isSingle) {
                    tt.setSelection(null);
                } else {
                    tt.setSelection(new TreeNode[0]);
                }
            } else {
                String[] selectedRowKeys = selectionValue.split(",");
                if (isSingle) {
                    tt.setRowKey(root, selectedRowKeys[0]);
                    tt.setSelection(tt.getRowNode());
                } else {
                    ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                    for (int i = 0; i < selectedRowKeys.length; ++i) {
                        tt.setRowKey(root, selectedRowKeys[i]);
                        TreeNode rowNode = tt.getRowNode();
                        if (rowNode == null) continue;
                        selectedNodes.add(rowNode);
                    }
                    tt.setSelection(selectedNodes.toArray(new TreeNode[selectedNodes.size()]));
                }
                tt.setRowKey(root, null);
            }
        }
        if (tt.isCheckboxSelection() && tt.isSelectionRequest(context)) {
            String selectedNodeRowKey = (String)params.get(clientId + "_instantSelection");
            tt.setRowKey(root, selectedNodeRowKey);
            TreeNode selectedNode = tt.getRowNode();
            ArrayList<String> descendantRowKeys = new ArrayList<String>();
            tt.populateRowKeys(selectedNode, descendantRowKeys);
            int size = descendantRowKeys.size();
            StringBuilder sb = SharedStringBuilder.get(context, SB_DECODE_SELECTION);
            for (int i = 0; i < size; ++i) {
                sb.append((String)descendantRowKeys.get(i));
                if (i == size - 1) continue;
                sb.append(",");
            }
            PrimeFaces.current().ajax().addCallbackParam("descendantRowKeys", sb.toString());
            sb.setLength(0);
            descendantRowKeys = null;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TreeTable tt = (TreeTable)component;
        TreeNode root = tt.getValue();
        String clientId = tt.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        this.preRender(context, tt);
        if (tt.isExpandRequest(context)) {
            String nodeKey = (String)params.get(clientId + "_expand");
            tt.setRowKey(root, nodeKey);
            TreeNode node = tt.getRowNode();
            node.setExpanded(true);
            if (tt.getExpandMode().equals("self")) {
                this.encodeNode(context, tt, root, node);
            } else {
                this.encodeNodeChildren(context, tt, root, node);
            }
        } else if (tt.isCollapseRequest(context)) {
            String nodeKey = (String)params.get(clientId + "_collapse");
            tt.setRowKey(root, nodeKey);
            TreeNode node = tt.getRowNode();
            node.setExpanded(false);
        } else if (tt.isFilterRequest(context)) {
            tt.updateFilteredValue(context, null);
            tt.setValue(null);
            tt.setFirst(0);
            String rppValue = (String)params.get(clientId + "_rppDD");
            if (rppValue != null && !"*".equals(rppValue)) {
                tt.setRows(Integer.parseInt(rppValue));
            }
            this.filter(context, tt, tt.getValue());
            this.sort(tt);
            this.encodeTbody(context, tt, tt.getValue(), true);
            if (tt.isMultiViewState()) {
                Map<String, FilterMeta> filterBy = tt.getFilterByAsMap();
                TreeTableState ts = tt.getMultiViewState(true);
                ts.setFilterBy(filterBy);
                if (tt.isPaginator()) {
                    ts.setFirst(tt.getFirst());
                    ts.setRows(tt.getRows());
                }
            }
        } else if (tt.isSortRequest(context)) {
            this.encodeSort(context, tt, root);
        } else if (tt.isRowEditRequest(context)) {
            this.encodeRowEdit(context, tt, root);
        } else if (tt.isCellEditRequest(context)) {
            this.encodeCellEdit(context, tt, root);
        } else if (tt.isPaginationRequest(context)) {
            tt.updatePaginationData(context);
            this.encodeNodeChildren(context, tt, root, root, tt.getFirst(), tt.getRows());
        } else {
            this.filter(context, tt, tt.getValue());
            this.sort(tt);
            this.encodeMarkup(context, tt);
            this.encodeScript(context, tt);
        }
    }

    protected void preRender(FacesContext context, TreeTable tt) {
        Map filterBy = tt.initFilterBy(context);
        if (tt.isFilterRequest(context)) {
            tt.updateFilterByValuesWithFilterRequest(context, filterBy);
        }
        tt.resetDynamicColumns();
        if (tt.isMultiViewState()) {
            tt.restoreMultiViewState();
        }
    }

    protected void encodeScript(FacesContext context, TreeTable tt) throws IOException {
        String selectionMode = tt.getSelectionMode();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TreeTable", tt).attr("selectionMode", selectionMode, null).attr("resizableColumns", tt.isResizableColumns(), false).attr("liveResize", tt.isLiveResize(), false).attr("scrollable", tt.isScrollable(), false).attr("scrollHeight", tt.getScrollHeight(), null).attr("scrollWidth", tt.getScrollWidth(), null).attr("nativeElements", tt.isNativeElements(), false).attr("expandMode", tt.getExpandMode(), "children").attr("disabledTextSelection", tt.isDisabledTextSelection(), true);
        if (tt.isStickyHeader()) {
            wb.attr("stickyHeader", true);
        }
        if (tt.isEditable()) {
            wb.attr("editable", true).attr("editMode", tt.getEditMode()).attr("saveOnCellBlur", tt.isSaveOnCellBlur(), true).attr("cellEditMode", tt.getCellEditMode(), "eager").attr("cellSeparator", tt.getCellSeparator(), null).attr("editInitEvent", tt.getEditInitEvent());
        }
        if (tt.isFilteringEnabled()) {
            wb.attr("filter", true).attr("filterEvent", tt.getFilterEvent(), null).attr("filterDelay", tt.getFilterDelay(), Integer.MAX_VALUE);
        }
        if (tt.isSortingEnabled()) {
            wb.attr("sorting", true);
            if (tt.isMultiSort()) {
                wb.attr("multiSort", true).nativeAttr("sortMetaOrder", tt.getSortMetaAsString(), null);
            }
            if (tt.isAllowUnsorting()) {
                wb.attr("allowUnsorting", true);
            }
        }
        if (tt.isPaginator()) {
            this.encodePaginatorConfig(context, tt, wb);
        }
        this.encodeClientBehaviors(context, tt);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tt.getClientId(context);
        boolean scrollable = tt.isScrollable();
        boolean resizable = tt.isResizableColumns();
        TreeNode root = tt.getValue();
        boolean hasPaginator = tt.isPaginator();
        if (root == null) {
            throw new FacesException("treeTable's value must not be null. ClientId: " + clientId);
        }
        if (!(root instanceof TreeNode)) {
            throw new FacesException("treeTable's value must be an instance of " + TreeNode.class.getName() + ". ClientId: " + clientId);
        }
        if (hasPaginator) {
            tt.calculateFirst();
        }
        if (root.getRowKey() == null) {
            root.setRowKey("root");
            tt.buildRowKeys(root);
            tt.initPreselection();
        }
        if (tt.isDefaultSort()) {
            this.sort(tt);
        }
        String containerClass = tt.isResizableColumns() ? "ui-treetable ui-treetable-resizable ui-widget" : "ui-treetable ui-widget";
        containerClass = scrollable ? containerClass + " " + "ui-treetable-scrollable" : containerClass;
        containerClass = tt.getStyleClass() == null ? containerClass : containerClass + " " + tt.getStyleClass();
        containerClass = tt.isShowUnselectableCheckbox() ? containerClass + " ui-treetable-checkbox-all" : containerClass;
        containerClass = tt.isShowGridlines() ? containerClass + " " + "ui-treetable-gridlines" : containerClass;
        containerClass = "small".equals(tt.getSize()) ? containerClass + " " + "ui-treetable-sm" : containerClass;
        containerClass = "large".equals(tt.getSize()) ? containerClass + " " + "ui-treetable-lg" : containerClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, null);
        if (tt.getStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getStyle(), null);
        }
        if (scrollable) {
            this.encodeScrollableMarkup(context, tt, root);
        } else {
            this.encodeRegularMarkup(context, tt, root);
        }
        if (tt.getSelectionMode() != null) {
            this.encodeStateHolder(context, tt, clientId + "_selection", tt.getSelectedRowKeysAsString());
        }
        if (scrollable) {
            this.encodeStateHolder(context, tt, clientId + "_scrollState", tt.getScrollState());
        }
        if (resizable) {
            this.encodeStateHolder(context, tt, tt.getClientId(context) + "_resizableColumnState", tt.getColumnsWidthForClientSide());
        }
        writer.endElement("div");
    }

    protected void encodeScrollableMarkup(FacesContext context, TreeTable tt, TreeNode root) throws IOException {
        String tableStyle = tt.getTableStyle();
        String tableStyleClass = tt.getTableStyleClass();
        boolean hasPaginator = tt.isPaginator();
        String paginatorPosition = tt.getPaginatorPosition();
        this.encodeScrollAreaStart(context, tt, "ui-widget-header ui-treetable-scrollable-header", "ui-treetable-scrollable-header-box", tableStyle, tableStyleClass, "header", "ui-treetable-header ui-widget-header ui-corner-top");
        if (hasPaginator && !"bottom".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, tt, "top");
        }
        this.encodeThead(context, tt);
        this.encodeScrollAreaEnd(context);
        this.encodeScrollBody(context, tt, root, tableStyle, tableStyleClass);
        this.encodeScrollAreaStart(context, tt, "ui-widget-header ui-treetable-scrollable-footer", "ui-treetable-scrollable-footer-box", tableStyle, tableStyleClass, "footer", "ui-treetable-footer ui-widget-header ui-corner-bottom");
        this.encodeTfoot(context, tt);
        if (hasPaginator && !"top".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, tt, "bottom");
        }
        this.encodeScrollAreaEnd(context);
    }

    protected void encodeScrollBody(FacesContext context, TreeTable tt, TreeNode root, String tableStyle, String tableStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String scrollHeight = tt.getScrollHeight();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-treetable-scrollable-body", null);
        if (scrollHeight != null && scrollHeight.indexOf(37) == -1) {
            writer.writeAttribute("style", (Object)("height:" + scrollHeight + "px"), null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeTbody(context, tt, root, false);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeScrollAreaStart(FacesContext context, TreeTable tt, String containerClass, String containerBoxClass, String tableStyle, String tableStyleClass, String facet, String facetClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        this.encodeFacet(context, tt, tt.getFacet(facet), facetClass);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerBoxClass, null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
    }

    protected void encodeScrollAreaEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeRegularMarkup(FacesContext context, TreeTable tt, TreeNode root) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean hasPaginator = tt.isPaginator();
        String paginatorPosition = tt.getPaginatorPosition();
        this.encodeFacet(context, tt, tt.getFacet("header"), "ui-treetable-header ui-widget-header ui-corner-top");
        if (tt.isPaginator() && !"bottom".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, tt, "top");
        }
        writer.startElement("table", (UIComponent)tt);
        writer.writeAttribute("role", (Object)"treegrid", null);
        if (tt.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getTableStyle(), null);
        }
        if (tt.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tt.getTableStyleClass(), null);
        }
        this.encodeThead(context, tt);
        this.encodeTfoot(context, tt);
        this.encodeTbody(context, tt, root, false);
        writer.endElement("table");
        if (hasPaginator && !"top".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, tt, "bottom");
        }
        this.encodeFacet(context, tt, tt.getFacet("footer"), "ui-treetable-footer ui-widget-header ui-corner-bottom");
    }

    protected void encodeThead(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = tt.getColumnGroup("header");
        String clientId = tt.getClientId(context);
        writer.startElement("thead", null);
        writer.writeAttribute("id", (Object)(clientId + "_head"), null);
        if (group != null && group.isRendered()) {
            context.getAttributes().put("org.primefaces.HELPER_RENDERER", "columnGroup");
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Row) {
                    Row headerRow = (Row)child;
                    String rowClass = headerRow.getStyleClass();
                    String rowStyle = headerRow.getStyle();
                    writer.startElement("tr", null);
                    writer.writeAttribute("role", (Object)"row", null);
                    if (rowClass != null) {
                        writer.writeAttribute("class", (Object)rowClass, null);
                    }
                    if (rowStyle != null) {
                        writer.writeAttribute("style", (Object)rowStyle, null);
                    }
                    for (UIComponent headerRowChild : headerRow.getChildren()) {
                        if (!headerRowChild.isRendered()) continue;
                        if (headerRowChild instanceof Column) {
                            this.encodeColumnHeader(context, tt, (Column)headerRowChild);
                            continue;
                        }
                        if (headerRowChild instanceof Columns) {
                            List<DynamicColumn> dynamicColumns = ((Columns)headerRowChild).getDynamicColumns();
                            for (DynamicColumn dynaColumn : dynamicColumns) {
                                dynaColumn.applyModel();
                                this.encodeColumnHeader(context, tt, dynaColumn);
                            }
                            continue;
                        }
                        headerRowChild.encodeAll(context);
                    }
                    writer.endElement("tr");
                    continue;
                }
                child.encodeAll(context);
            }
            context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("role", (Object)"row", null);
            List<UIColumn> columns = tt.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof Column) {
                    this.encodeColumnHeader(context, tt, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnHeader(context, tt, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    protected void encodeTbody(FacesContext context, TreeTable tt, TreeNode root, boolean dataOnly) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tt.getClientId(context);
        boolean empty = root == null || root.getChildCount() == 0;
        UIComponent emptyFacet = tt.getFacet("emptyMessage");
        if (!dataOnly) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)(clientId + "_data"), null);
            writer.writeAttribute("class", (Object)"ui-treetable-data ui-widget-content", null);
        }
        if (empty) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-treetable-empty-message", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)tt.getColumnsCount(), null);
            if (ComponentUtils.shouldRenderFacet(emptyFacet)) {
                emptyFacet.encodeAll(context);
            } else {
                writer.writeText((Object)tt.getEmptyMessage(), "emptyMessage");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (root != null) {
            if (tt.isPaginator()) {
                int first = tt.getFirst();
                int rows = tt.getRows() == 0 ? tt.getRowCount() : tt.getRows();
                this.encodeNodeChildren(context, tt, root, root, first, rows);
            } else {
                this.encodeNodeChildren(context, tt, root, root);
            }
        }
        tt.setRowKey(root, null);
        if (!dataOnly) {
            writer.endElement("tbody");
        }
    }

    protected void encodeNode(FacesContext context, TreeTable tt, TreeNode root, TreeNode treeNode) throws IOException {
        String userRowStyleClass;
        ResponseWriter writer = context.getResponseWriter();
        String rowKey = treeNode.getRowKey();
        String parentRowKey = treeNode.getParent().getRowKey();
        tt.setRowKey(root, rowKey);
        String icon = treeNode.isExpanded() ? "ui-treetable-toggler ui-icon ui-icon-triangle-1-s ui-c" : "ui-treetable-toggler ui-icon ui-icon-triangle-1-e ui-c";
        int depth = rowKey.split("_").length - 1;
        String selectionMode = tt.getSelectionMode();
        boolean selectionEnabled = selectionMode != null;
        boolean selectable = treeNode.isSelectable() && selectionEnabled;
        boolean checkboxSelection = selectionEnabled && "checkbox".equals(selectionMode);
        boolean selected = treeNode.isSelected();
        boolean partialSelected = treeNode.isPartialSelected();
        boolean nativeElements = tt.isNativeElements();
        List<UIColumn> columns = tt.getColumns();
        String rowStyleClass = selected ? "ui-widget-content ui-state-highlight ui-selected" : "ui-widget-content";
        rowStyleClass = selectable ? rowStyleClass + " " + "ui-treetable-selectable-node" : rowStyleClass;
        rowStyleClass = rowStyleClass + " " + treeNode.getType();
        rowStyleClass = rowStyleClass + " ui-node-level-" + rowKey.split("_").length;
        if (partialSelected) {
            rowStyleClass = rowStyleClass + " " + "ui-treetable-partialselected";
        }
        if ((userRowStyleClass = tt.getRowStyleClass()) != null) {
            rowStyleClass = rowStyleClass + " " + userRowStyleClass;
        }
        if (tt.isEditingRow()) {
            rowStyleClass = rowStyleClass + " " + "ui-row-editing";
        }
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(tt.getClientId(context) + "_node_" + rowKey), null);
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        writer.writeAttribute("role", (Object)"row", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(treeNode.isExpanded()), null);
        writer.writeAttribute("data-rk", (Object)rowKey, null);
        if (parentRowKey != null) {
            writer.writeAttribute("data-prk", (Object)parentRowKey, null);
        }
        if (selectionEnabled) {
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        }
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            ColumnMeta columnMeta = tt.getColumnMeta().get(column.getColumnKey((UIComponent)tt, rowKey));
            if (column.isDynamic()) {
                ((DynamicColumn)column).applyModel();
            }
            if (!column.isRendered()) continue;
            boolean columnVisible = column.isVisible();
            if (columnMeta != null && columnMeta.getVisible() != null) {
                columnVisible = columnMeta.getVisible();
            }
            String columnStyleClass = column.getStyleClass();
            String columnStyle = column.getStyle();
            int rowspan = column.getRowspan();
            int colspan = column.getColspan();
            int responsivePriority = column.getResponsivePriority();
            if (responsivePriority > 0) {
                String string = columnStyleClass = columnStyleClass == null ? "ui-column-p-" + responsivePriority : columnStyleClass + " ui-column-p-" + responsivePriority;
            }
            if (column.getCellEditor() != null) {
                String string = columnStyleClass = columnStyleClass == null ? "ui-editable-column" : "ui-editable-column " + columnStyleClass;
            }
            if (!columnVisible) {
                columnStyleClass = columnStyleClass == null ? "ui-helper-hidden" : columnStyleClass + " " + "ui-helper-hidden";
            }
            writer.startElement("td", null);
            writer.writeAttribute("role", (Object)"gridcell", null);
            if (columnStyle != null) {
                writer.writeAttribute("style", (Object)columnStyle, null);
            }
            if (columnStyleClass != null) {
                writer.writeAttribute("class", (Object)columnStyleClass, null);
            }
            if (rowspan != 1) {
                writer.writeAttribute("rowspan", (Object)rowspan, null);
            }
            if (colspan != 1) {
                writer.writeAttribute("colspan", (Object)colspan, null);
            }
            if (i == 0) {
                for (int j = 0; j < depth; ++j) {
                    writer.startElement("span", null);
                    writer.writeAttribute("class", (Object)"ui-treetable-indent", null);
                    writer.endElement("span");
                }
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)icon, null);
                if (treeNode.isLeaf()) {
                    writer.writeAttribute("style", (Object)"visibility:hidden", null);
                }
                writer.endElement("span");
                if (checkboxSelection) {
                    if (!nativeElements) {
                        RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
                    } else {
                        this.renderNativeCheckbox(context, tt, selected, partialSelected);
                    }
                }
            }
            column.renderChildren(context);
            writer.endElement("td");
        }
        writer.endElement("tr");
        if (treeNode.isExpanded()) {
            this.encodeNodeChildren(context, tt, root, treeNode);
        }
    }

    public void encodeColumnHeader(FacesContext context, TreeTable tt, UIColumn column) throws IOException {
        String sortIcon;
        int responsivePriority;
        if (!column.isRendered()) {
            return;
        }
        ColumnMeta columnMeta = tt.getColumnMeta().get(column.getColumnKey());
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        boolean columnVisible = column.isVisible();
        if (columnMeta != null && columnMeta.getVisible() != null) {
            columnVisible = columnMeta.getVisible();
        }
        int colspan = column.getColspan();
        int rowspan = column.getRowspan();
        boolean sortable = tt.isColumnSortable(context, column);
        boolean filterable = tt.isColumnFilterable(column);
        SortMeta sortMeta = null;
        String style = column.getStyle();
        String width = column.getWidth();
        String columnClass = sortable ? "ui-state-default ui-sortable-column" : "ui-state-default";
        columnClass = !columnVisible ? columnClass + " " + "ui-helper-hidden" : columnClass;
        columnClass = !column.isToggleable() ? columnClass + " " + "ui-static-column" : columnClass;
        String userColumnClass = column.getStyleClass();
        if (column.isResizable()) {
            columnClass = columnClass + " " + "ui-resizable-column";
        }
        if (userColumnClass != null) {
            columnClass = columnClass + " " + userColumnClass;
        }
        String string = columnClass = filterable ? columnClass + " " + "ui-filter-column" : columnClass;
        if (sortable && (sortMeta = tt.getSortByAsMap().get(column.getColumnKey())).isActive()) {
            columnClass = columnClass + " ui-state-active";
        }
        if ((responsivePriority = column.getResponsivePriority()) > 0) {
            columnClass = columnClass + " ui-column-p-" + responsivePriority;
        }
        if (width != null) {
            String unit = this.endsWithLenghtUnit(width) ? "" : "px";
            style = style != null ? style + ";width:" + width + unit : "width:" + width + unit;
        }
        String ariaHeaderLabel = this.getHeaderLabel(context, column);
        writer.startElement("th", null);
        writer.writeAttribute("id", (Object)column.getContainerClientId(context), null);
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.writeAttribute("role", (Object)"columnheader", null);
        writer.writeAttribute("aria-label", (Object)ariaHeaderLabel, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-column-title", null);
        if (ComponentUtils.shouldRenderFacet(header)) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.writeText((Object)headerText, null);
        }
        writer.endElement("span");
        if (sortable && sortMeta != null && (sortIcon = this.resolveDefaultSortIcon(sortMeta)) != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)sortIcon, null);
            writer.endElement("span");
            if (tt.isMultiSort()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-sortable-column-badge ui-helper-hidden", null);
                writer.endElement("span");
            }
        }
        if (filterable) {
            this.encodeFilter(context, tt, column);
        }
        writer.endElement("th");
    }

    protected String resolveDefaultSortIcon(SortMeta sortMeta) {
        SortOrder sortOrder = sortMeta.getOrder();
        String sortIcon = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
        if (sortOrder.isAscending()) {
            sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
        } else if (sortOrder.isDescending()) {
            sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
        }
        return sortIcon;
    }

    protected void encodeFilter(FacesContext context, TreeTable tt, UIColumn column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent filterFacet = column.getFacet("filter");
        if (!ComponentUtils.shouldRenderFacet(filterFacet)) {
            String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
            boolean disableTabbing = tt.getScrollWidth() != null;
            String filterId = column.getContainerClientId(context) + separator + "filter";
            String filterStyleClass = column.getFilterStyleClass();
            Object filterValue = tt.getFilterValue(column);
            filterValue = filterValue == null ? "" : filterValue.toString();
            filterStyleClass = filterStyleClass == null ? "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all" : "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all " + filterStyleClass;
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("value", filterValue, null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            if (disableTabbing) {
                writer.writeAttribute("tabindex", (Object)"-1", null);
            }
            if (column.getFilterStyle() != null) {
                writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
            }
            if (column.getFilterMaxLength() != Integer.MAX_VALUE) {
                writer.writeAttribute("maxlength", (Object)column.getFilterMaxLength(), null);
            }
            writer.endElement("input");
        } else {
            Object filterValue = tt.getFilterValue(column);
            if (filterValue != null) {
                ((ValueHolder)filterFacet).setValue(filterValue);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-column-customfilter", null);
            filterFacet.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected void encodeNodeChildren(FacesContext context, TreeTable tt, TreeNode root, TreeNode treeNode) throws IOException {
        int childCount = treeNode.getChildCount();
        this.encodeNodeChildren(context, tt, root, treeNode, 0, childCount);
    }

    protected void encodeNodeChildren(FacesContext context, TreeTable tt, TreeNode root, TreeNode treeNode, int first, int size) throws IOException {
        if (size > 0) {
            List<TreeNode> children = treeNode.getChildren();
            int last = first + size;
            int childCount = treeNode.getChildCount();
            if (last > childCount) {
                last = childCount;
            }
            for (int i = first; i < last; ++i) {
                this.encodeNode(context, tt, root, children.get(i));
            }
        }
    }

    protected void encodeFacet(FacesContext context, TreeTable tt, UIComponent facet, String styleClass) throws IOException {
        if (!ComponentUtils.shouldRenderFacet(facet)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeTfoot(FacesContext context, TreeTable tt) throws IOException {
        boolean shouldRenderFooter;
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = tt.getColumnGroup("footer");
        boolean hasFooterColumn = tt.hasFooterColumn();
        boolean bl = shouldRenderFooter = hasFooterColumn || group != null;
        if (!shouldRenderFooter) {
            return;
        }
        writer.startElement("tfoot", null);
        if (group != null && group.isRendered()) {
            context.getAttributes().put("org.primefaces.HELPER_RENDERER", "columnGroup");
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Row) {
                    Row footerRow = (Row)child;
                    String rowClass = footerRow.getStyleClass();
                    String rowStyle = footerRow.getStyle();
                    writer.startElement("tr", null);
                    if (rowClass != null) {
                        writer.writeAttribute("class", (Object)rowClass, null);
                    }
                    if (rowStyle != null) {
                        writer.writeAttribute("style", (Object)rowStyle, null);
                    }
                    for (UIComponent footerRowChild : footerRow.getChildren()) {
                        if (!footerRowChild.isRendered()) continue;
                        if (footerRowChild instanceof Column) {
                            this.encodeColumnFooter(context, tt, (Column)footerRowChild);
                            continue;
                        }
                        if (footerRowChild instanceof Columns) {
                            List<DynamicColumn> dynamicColumns = ((Columns)footerRowChild).getDynamicColumns();
                            for (DynamicColumn dynaColumn : dynamicColumns) {
                                dynaColumn.applyModel();
                                this.encodeColumnFooter(context, tt, dynaColumn);
                            }
                            continue;
                        }
                        footerRowChild.encodeAll(context);
                    }
                    writer.endElement("tr");
                    continue;
                }
                child.encodeAll(context);
            }
            context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        } else if (hasFooterColumn) {
            writer.startElement("tr", null);
            List<UIColumn> columns = tt.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof Column) {
                    this.encodeColumnFooter(context, tt, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnFooter(context, tt, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    public void encodeColumnFooter(FacesContext context, TreeTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        int colspan = column.getColspan();
        int rowspan = column.getRowspan();
        UIComponent footerFacet = column.getFacet("footer");
        String footerText = column.getFooterText();
        String style = column.getStyle();
        String columnStyleClass = column.getStyleClass();
        columnStyleClass = columnStyleClass == null ? "ui-state-default" : "ui-state-default " + columnStyleClass;
        int responsivePriority = column.getResponsivePriority();
        if (responsivePriority > 0) {
            columnStyleClass = columnStyleClass + " ui-column-p-" + responsivePriority;
        }
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)columnStyleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (ComponentUtils.shouldRenderFacet(footerFacet)) {
            footerFacet.encodeAll(context);
        } else if (footerText != null) {
            writer.writeText((Object)footerText, null);
        }
        writer.endElement("td");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeStateHolder(FacesContext context, TreeTable tt, String name, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    protected String resolveSortIcon(SortMeta sortMeta) {
        if (sortMeta == null) {
            return null;
        }
        SortOrder sortOrder = sortMeta.getOrder();
        if (sortOrder == SortOrder.ASCENDING) {
            return "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
        }
        if (sortOrder == SortOrder.DESCENDING) {
            return "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
        }
        return null;
    }

    protected void decodeSort(FacesContext context, TreeTable tt) {
        String[] sortOrders;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        String[] sortKeys = sortKey.split(",");
        if (sortKeys.length != (sortOrders = sortDir.split(",")).length) {
            throw new FacesException("sortKeys != sortDirs");
        }
        Map<String, SortMeta> sortByMap = tt.getSortByAsMap();
        Map<String, Integer> sortKeysIndexes = IntStream.range(0, sortKeys.length).boxed().collect(Collectors.toMap(i -> sortKeys[i], i -> i));
        for (Map.Entry<String, SortMeta> entry : sortByMap.entrySet()) {
            SortMeta sortBy = entry.getValue();
            if (!(sortBy.getComponent() instanceof UIColumn)) continue;
            Integer index = sortKeysIndexes.get(entry.getKey());
            if (index != null) {
                sortBy.setOrder(SortOrder.of(sortOrders[index]));
                sortBy.setPriority(index);
                continue;
            }
            sortBy.setOrder(SortOrder.UNSORTED);
            sortBy.setPriority(SortMeta.MIN_PRIORITY);
        }
    }

    protected void encodeSort(FacesContext context, TreeTable tt, TreeNode root) throws IOException {
        this.sort(tt);
        this.encodeTbody(context, tt, root, true);
        if (tt.isMultiViewState()) {
            Map<String, SortMeta> sortMeta = tt.getSortByAsMap();
            TreeTableState ts = tt.getMultiViewState(true);
            ts.setSortBy(sortMeta);
            if (tt.isPaginator()) {
                ts.setFirst(tt.getFirst());
                ts.setRows(tt.getRows());
            }
        }
    }

    public void sort(TreeTable tt) {
        TreeNode root = tt.getValue();
        if (root == null) {
            return;
        }
        Map<String, SortMeta> sortBy = tt.getSortByAsMap();
        if (sortBy.isEmpty()) {
            return;
        }
        Locale dataLocale = tt.resolveDataLocale();
        tt.forEachColumn(column -> {
            SortMeta meta = (SortMeta)sortBy.get(column.getColumnKey());
            if (meta == null || !meta.isActive()) {
                return true;
            }
            if (column instanceof DynamicColumn) {
                ((DynamicColumn)column).applyStatelessModel();
            }
            TreeUtils.sortNode(root, new TreeNodeComparator(meta.getSortBy(), tt.getVar(), meta.getOrder(), meta.getFunction(), meta.isCaseSensitiveSort(), dataLocale));
            tt.updateRowKeys(root);
            return true;
        });
        String selectedRowKeys = tt.getSelectedRowKeysAsString();
        if (selectedRowKeys != null) {
            PrimeFaces.current().ajax().addCallbackParam("selection", selectedRowKeys);
        }
    }

    protected void renderNativeCheckbox(FacesContext context, TreeTable tt, boolean checked, boolean partialSelected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)(tt.getContainerClientId(context) + "_checkbox"), null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (partialSelected) {
            writer.writeAttribute("class", (Object)"ui-treetable-indeterminate", null);
        }
        writer.endElement("input");
    }

    public void encodeRowEdit(FacesContext context, TreeTable tt, TreeNode root) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String editedRowKey = (String)params.get(clientId + "_rowEditIndex");
        String action = (String)params.get(clientId + "_rowEditAction");
        tt.setRowKey(root, editedRowKey);
        TreeNode node = tt.getRowNode();
        if ("cancel".equals(action)) {
            VisitContext visitContext = null;
            for (UIColumn column : tt.getColumns()) {
                for (UIComponent grandkid : column.getChildren()) {
                    if (!(grandkid instanceof CellEditor)) continue;
                    UIComponent inputFacet = grandkid.getFacet("input");
                    if (inputFacet instanceof EditableValueHolder) {
                        ((EditableValueHolder)inputFacet).resetValue();
                        continue;
                    }
                    if (visitContext == null) {
                        visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                    }
                    inputFacet.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                }
            }
        }
        this.encodeNode(context, tt, root, node);
    }

    public void encodeCellEdit(FacesContext context, TreeTable tt, TreeNode root) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
        String rowKey = cellInfo[0];
        int cellIndex = Integer.parseInt(cellInfo[1]);
        int i = -1;
        UIColumn column = null;
        for (UIColumn col : tt.getColumns()) {
            if (!col.isRendered() || ++i != cellIndex) continue;
            column = col;
            break;
        }
        if (column == null) {
            throw new FacesException("No column found for cellIndex: " + cellIndex);
        }
        tt.setRowKey(root, rowKey);
        if (column.isDynamic()) {
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyStatelessModel();
        }
        if (tt.isCellEditCancelRequest(context) || tt.isCellEditInitRequest(context)) {
            column.getCellEditor().getFacet("input").encodeAll(context);
        } else {
            column.getCellEditor().getFacet("output").encodeAll(context);
        }
        if (column.isDynamic()) {
            ((DynamicColumn)column).cleanStatelessModel();
        }
    }

    public void filter(FacesContext context, TreeTable tt, TreeNode root) throws IOException {
        Map<String, FilterMeta> filterBy = tt.getFilterByAsMap();
        if (filterBy.isEmpty()) {
            return;
        }
        Locale filterLocale = LocaleUtils.getCurrentLocale(context);
        List<String> filteredRowKeys = tt.getFilteredRowKeys();
        filteredRowKeys.clear();
        this.collectFilteredRowKeys(context, tt, root, root, filterBy, filterLocale, filteredRowKeys);
        TreeNode filteredValue = this.cloneTreeNode(tt, root, root.getParent());
        this.createFilteredValueFromRowKeys(tt, root, filteredValue, filteredRowKeys);
        tt.updateFilteredValue(context, filteredValue);
        tt.setValue(filteredValue);
        tt.setRowKey(root, null);
        if (tt.isPaginator()) {
            PrimeFaces.current().ajax().addCallbackParam("totalRecords", filteredValue.getChildCount());
        }
        if (tt.getSelectedRowKeysAsString() != null) {
            PrimeFaces.current().ajax().addCallbackParam("selection", tt.getSelectedRowKeysAsString());
        }
    }

    protected void collectFilteredRowKeys(FacesContext context, TreeTable tt, TreeNode root, TreeNode node, Map<String, FilterMeta> filterBy, Locale filterLocale, List<String> filteredRowKeys) throws IOException {
        ELContext elContext = context.getELContext();
        FilterMeta globalFilter = filterBy.get("globalFilter");
        boolean hasGlobalFilterFunction = globalFilter != null && globalFilter.getConstraint() instanceof FunctionFilterConstraint;
        int childCount = node.getChildCount();
        AtomicBoolean localMatch = new AtomicBoolean();
        AtomicBoolean globalMatch = new AtomicBoolean();
        for (int i = 0; i < childCount; ++i) {
            TreeNode childNode = node.getChildren().get(i);
            String rowKey = childNode.getRowKey();
            tt.setRowKey(root, rowKey);
            localMatch.set(true);
            globalMatch.set(false);
            if (hasGlobalFilterFunction) {
                globalMatch.set(globalFilter.getConstraint().isMatching(context, childNode, globalFilter.getFilterValue(), filterLocale));
            }
            tt.forEachColumn(column -> {
                Object filterValue;
                FilterConstraint constraint;
                FilterMeta filter = (FilterMeta)filterBy.get(column.getColumnKey((UIComponent)tt, rowKey));
                if (filter == null || filter.isGlobalFilter()) {
                    return true;
                }
                filter.setColumn((UIColumn)column);
                Object columnValue = filter.getLocalValue(elContext);
                if (globalFilter != null && globalFilter.isActive() && !globalMatch.get() && !hasGlobalFilterFunction) {
                    constraint = globalFilter.getConstraint();
                    filterValue = globalFilter.getFilterValue();
                    globalMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                }
                if (!filter.isActive()) {
                    return true;
                }
                constraint = filter.getConstraint();
                filterValue = filter.getFilterValue();
                localMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                return localMatch.get();
            });
            boolean matches = localMatch.get();
            if (globalFilter != null && globalFilter.isActive()) {
                boolean bl = matches = matches && globalMatch.get();
            }
            if (matches) {
                filteredRowKeys.add(rowKey);
            }
            this.collectFilteredRowKeys(context, tt, root, childNode, filterBy, filterLocale, filteredRowKeys);
        }
    }

    private void createFilteredValueFromRowKeys(TreeTable tt, TreeNode node, TreeNode filteredNode, List<String> filteredRowKeys) {
        int childCount = node.getChildCount();
        block0: for (int i = 0; i < childCount; ++i) {
            TreeNode childNode = node.getChildren().get(i);
            String rowKeyOfChildNode = childNode.getRowKey();
            for (String rk : filteredRowKeys) {
                if (!rk.equals(rowKeyOfChildNode) && !rk.startsWith(rowKeyOfChildNode + "_") && !rowKeyOfChildNode.startsWith(rk + "_")) continue;
                TreeNode newNode = this.cloneTreeNode(tt, childNode, filteredNode);
                if (rk.startsWith(rowKeyOfChildNode + "_")) {
                    newNode.setExpanded(true);
                }
                this.createFilteredValueFromRowKeys(tt, childNode, newNode, filteredRowKeys);
                continue block0;
            }
        }
    }

    protected TreeNode cloneTreeNode(TreeTable tt, TreeNode node, TreeNode parent) {
        TreeNode clone = null;
        if (CheckboxTreeNode.class.equals(node.getClass())) {
            clone = new CheckboxTreeNode(node.getType(), node.getData(), parent);
        } else if (DefaultTreeNode.class.equals(node.getClass())) {
            clone = new DefaultTreeNode(node.getType(), node.getData(), parent);
        }
        if (clone == null && tt.isCloneOnFilter()) {
            if (node instanceof Cloneable) {
                try {
                    Method cloneMethod = node.getClass().getMethod("clone", new Class[0]);
                    if (cloneMethod != null) {
                        cloneMethod.setAccessible(true);
                        clone = (TreeNode)cloneMethod.invoke((Object)node, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warning(node.getClass().getName() + " declares Cloneable but no clone() method found!");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.warning(node.getClass().getName() + "#clone() not accessible!");
                }
            } else {
                Constructor<?> ctor2;
                try {
                    ctor2 = node.getClass().getConstructor(node.getClass());
                    clone = (TreeNode)ctor2.newInstance(node);
                }
                catch (NoSuchMethodException ctor2) {
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    LOGGER.warning("Could not clone " + node.getClass().getName() + " via public " + node.getClass().getSimpleName() + "() constructor!");
                }
                if (clone == null) {
                    try {
                        ctor2 = node.getClass().getConstructor(String.class, Object.class, TreeNode.class);
                        clone = (TreeNode)ctor2.newInstance(node.getType(), node.getData(), parent);
                    }
                    catch (NoSuchMethodException ctor3) {
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        LOGGER.warning("Could not clone " + node.getClass().getName() + " via public " + node.getClass().getSimpleName() + "(String type, Object data, TreeNode parent) constructor!");
                    }
                }
            }
        }
        if (clone == null) {
            clone = node instanceof CheckboxTreeNode ? new CheckboxTreeNode(node.getType(), node.getData(), parent) : new DefaultTreeNode(node.getType(), node.getData(), parent);
        }
        clone.setSelected(node.isSelected());
        clone.setExpanded(node.isExpanded());
        return clone;
    }
}

