/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.wizard;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.wizard.WizardBase;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.event.FlowEvent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Wizard
extends WizardBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Wizard";
    public static final String STEP_STATUS_CLASS = "ui-wizard-step-titles ui-helper-reset ui-helper-clearfix";
    public static final String STEP_CLASS = "ui-wizard-step-title ui-state-default ui-corner-all";
    public static final String ACTIVE_STEP_CLASS = "ui-wizard-step-title ui-state-default ui-state-highlight ui-corner-all";
    public static final String BACK_BUTTON_CLASS = "ui-wizard-nav-back";
    public static final String NEXT_BUTTON_CLASS = "ui-wizard-nav-next";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("next", null).put("back", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void processDecodes(FacesContext context) {
        Tab step;
        this.decode(context);
        if ((!this.isBackRequest(context) || this.isUpdateModelOnPrev() && this.isBackRequest(context)) && (step = this.getStepToProcess()) != null) {
            step.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        Tab step;
        if (!this.isRendered()) {
            return;
        }
        if ((!this.isBackRequest(context) || this.isUpdateModelOnPrev() && this.isBackRequest(context)) && (step = this.getStepToProcess()) != null) {
            step.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        ELContext elContext;
        ValueExpression expr;
        Tab step;
        if (!this.isRendered()) {
            return;
        }
        if ((!this.isBackRequest(context) || this.isUpdateModelOnPrev() && this.isBackRequest(context)) && (step = this.getStepToProcess()) != null) {
            step.processUpdates(context);
        }
        if ((expr = ValueExpressionAnalyzer.getExpression(elContext = this.getFacesContext().getELContext(), this.getValueExpression(WizardBase.PropertyKeys.step.toString()))) != null && !expr.isReadOnly(elContext)) {
            expr.setValue(elContext, (Object)this.getStep());
            this.resetStep();
        }
    }

    public Tab getStepToProcess() {
        String currentStepId = this.getStep();
        if (LangUtils.isValueBlank(currentStepId)) {
            return null;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.getId().equals(currentStepId)) continue;
            return (Tab)child;
        }
        return null;
    }

    public boolean isBackRequest(FacesContext context) {
        return ComponentUtils.isRequestSource((UIComponent)this, context) && "back".equals(this.getRequestDirection(context));
    }

    public String getRequestDirection(FacesContext context) {
        return (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_direction");
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof FlowEvent) {
            FlowEvent flowEvent = (FlowEvent)event;
            FacesContext context = this.getFacesContext();
            MethodExpression me = this.getFlowListener();
            if (me != null) {
                String step = (String)me.invoke(context.getELContext(), new Object[]{event});
                this.setStep(step);
            } else {
                this.setStep(flowEvent.getNewStep());
            }
        }
    }

    protected void resetStep() {
        this.getStateHelper().remove((Serializable)((Object)WizardBase.PropertyKeys.step));
    }
}

