/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.event.AbortProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.primefaces.application.resource.DynamicResourcesPhaseListener;
import org.primefaces.context.PartialResponseWriterWrapper;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.shaded.json.JSONArray;
import org.primefaces.shaded.json.JSONException;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.BeanUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.ResourceUtils;

public class PrimePartialResponseWriter
extends PartialResponseWriterWrapper {
    private static final Map<String, String> CALLBACK_EXTENSION_PARAMS;
    private boolean metadataRendered;

    public PrimePartialResponseWriter(PartialResponseWriter wrapped) {
        super(wrapped);
    }

    @Override
    public void endDocument() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        if (requestContext != null) {
            try {
                if (context.isValidationFailed()) {
                    requestContext.getCallbackParams().put("validationFailed", true);
                }
                this.encodeCallbackParams(requestContext.getCallbackParams());
                this.encodeScripts(requestContext);
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
        }
        super.endDocument();
    }

    @Override
    public void startError(String errorName) throws IOException {
        this.startMetadataIfNecessary();
        super.startError(errorName);
    }

    @Override
    public void startEval() throws IOException {
        this.startMetadataIfNecessary();
        super.startEval();
    }

    @Override
    public void startExtension(Map<String, String> attributes) throws IOException {
        this.startMetadataIfNecessary();
        super.startExtension(attributes);
    }

    @Override
    public void startInsertAfter(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        super.startInsertAfter(targetId);
    }

    @Override
    public void startInsertBefore(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        super.startInsertBefore(targetId);
    }

    @Override
    public void startUpdate(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        super.startUpdate(targetId);
    }

    @Override
    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startMetadataIfNecessary();
        super.updateAttributes(targetId, attributes);
    }

    @Override
    public void delete(String targetId) throws IOException {
        this.startMetadataIfNecessary();
        super.delete(targetId);
    }

    public void encodeJSONObject(String paramName, JSONObject jsonObject) throws IOException, JSONException {
        String json = jsonObject.toString();
        json = EscapeUtils.forXml(json);
        this.getWrapped().write("\"");
        this.getWrapped().write(paramName);
        this.getWrapped().write("\":");
        this.getWrapped().write(json);
    }

    public void encodeJSONArray(String paramName, JSONArray jsonArray) throws IOException, JSONException {
        String json = jsonArray.toString();
        json = EscapeUtils.forXml(json);
        this.getWrapped().write("\"");
        this.getWrapped().write(paramName);
        this.getWrapped().write("\":");
        this.getWrapped().write(json);
    }

    public void encodeJSONValue(String paramName, Object paramValue) throws IOException, JSONException {
        String json = new JSONObject().put(paramName, paramValue).toString();
        json = EscapeUtils.forXml(json);
        this.getWrapped().write(json.substring(1, json.length() - 1));
    }

    public void encodeCallbackParams(Map<String, Object> params) throws IOException, JSONException {
        if (params != null && !params.isEmpty()) {
            this.startExtension(CALLBACK_EXTENSION_PARAMS);
            this.getWrapped().write("{");
            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String paramName = entry.getKey();
                Object paramValue = entry.getValue();
                if (paramValue == null) {
                    this.encodeJSONValue(paramName, null);
                } else if (paramValue instanceof JSONObject) {
                    this.encodeJSONObject(paramName, (JSONObject)paramValue);
                } else if (paramValue instanceof JSONArray) {
                    this.encodeJSONArray(paramName, (JSONArray)paramValue);
                } else if (BeanUtils.isBean(paramValue)) {
                    this.encodeJSONObject(paramName, new JSONObject(paramValue));
                } else {
                    this.encodeJSONValue(paramName, paramValue);
                }
                if (!it.hasNext()) continue;
                this.getWrapped().write(",");
            }
            this.getWrapped().write("}");
            this.endExtension();
        }
    }

    protected void encodeScripts(PrimeRequestContext requestContext) throws IOException {
        List<String> initScripts = requestContext.getInitScriptsToExecute();
        List<String> scripts = requestContext.getScriptsToExecute();
        if (!initScripts.isEmpty() || !scripts.isEmpty()) {
            int i;
            this.startEval();
            for (i = 0; i < initScripts.size(); ++i) {
                this.getWrapped().write(initScripts.get(i));
                this.getWrapped().write(59);
            }
            for (i = 0; i < scripts.size(); ++i) {
                this.getWrapped().write(scripts.get(i));
                this.getWrapped().write(59);
            }
            this.endEval();
        }
    }

    protected void startMetadataIfNecessary() throws IOException {
        if (this.metadataRendered) {
            return;
        }
        this.metadataRendered = true;
        FacesContext context = FacesContext.getCurrentInstance();
        PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
        if (applicationContext != null) {
            try {
                UIViewRoot viewRoot = context.getViewRoot();
                if (viewRoot != null) {
                    String parameterNamespace;
                    if (viewRoot instanceof NamingContainer && (parameterNamespace = viewRoot.getContainerClientId(context)) != null && parameterNamespace.length() > 0) {
                        String parameterPrefix = parameterNamespace;
                        if (applicationContext.getEnvironment().isAtLeastJsf23()) {
                            parameterPrefix = parameterPrefix + UINamingContainer.getSeparatorChar((FacesContext)context);
                        }
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("parameterPrefix", parameterPrefix);
                        this.encodeCallbackParams(params);
                    }
                    if (context.isPostback() && !context.getPartialViewContext().isRenderAll() && !applicationContext.getEnvironment().isAtLeastJsf23()) {
                        List<ResourceUtils.ResourceInfo> initialResources = DynamicResourcesPhaseListener.getInitialResources(context);
                        List<ResourceUtils.ResourceInfo> currentResources = ResourceUtils.getComponentResources(context);
                        if (initialResources != null && currentResources != null && currentResources.size() > initialResources.size()) {
                            ArrayList<ResourceUtils.ResourceInfo> newResources = new ArrayList<ResourceUtils.ResourceInfo>(currentResources);
                            newResources.removeAll(initialResources);
                            boolean updateStarted = false;
                            for (int i = 0; i < newResources.size(); ++i) {
                                ResourceUtils.ResourceInfo resourceInfo = (ResourceUtils.ResourceInfo)newResources.get(i);
                                if (!updateStarted) {
                                    ((PartialResponseWriter)this.getWrapped()).startUpdate("jakarta.faces.Resource");
                                    updateStarted = true;
                                }
                                resourceInfo.getResource().encodeAll(context);
                            }
                            if (updateStarted) {
                                ((PartialResponseWriter)this.getWrapped()).endUpdate();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
        }
    }

    static {
        HashMap<String, String> callbackExtensionParams = new HashMap<String, String>();
        callbackExtensionParams.put("ln", "primefaces");
        callbackExtensionParams.put("type", "args");
        CALLBACK_EXTENSION_PARAMS = Collections.unmodifiableMap(callbackExtensionParams);
    }
}

