/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.CSVBuilder;
import org.primefaces.util.StyleClassBuilder;
import org.primefaces.util.WidgetBuilder;

public class PrimeRequestContext {
    public static final String INSTANCE_KEY = PrimeRequestContext.class.getName();
    private static final String CALLBACK_PARAMS_KEY = "CALLBACK_PARAMS";
    private static final String EXECUTE_INIT_SCRIPTS_KEY = "EXECUTE_INIT_SCRIPTS";
    private static final String EXECUTE_SCRIPTS_KEY = "EXECUTE_SCRIPTS";
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private WidgetBuilder widgetBuilder;
    private StyleClassBuilder styleClassBuilder;
    private AjaxRequestBuilder ajaxRequestBuilder;
    private CSVBuilder csvBuilder;
    private FacesContext context;
    private PrimeApplicationContext applicationContext;
    private Boolean ignoreAutoUpdate;
    private Boolean rtl;
    private Boolean touchable;
    private Boolean secure;
    private Boolean flex;

    public PrimeRequestContext(FacesContext context) {
        this.context = context;
    }

    public static PrimeRequestContext getCurrentInstance() {
        return PrimeRequestContext.getCurrentInstance(FacesContext.getCurrentInstance());
    }

    public static PrimeRequestContext getCurrentInstance(FacesContext facesContext) {
        if (facesContext == null) {
            return null;
        }
        PrimeRequestContext context = (PrimeRequestContext)facesContext.getAttributes().get(INSTANCE_KEY);
        if (context == null) {
            context = new PrimeRequestContext(facesContext);
            PrimeRequestContext.setCurrentInstance(context, facesContext);
        }
        return context;
    }

    public static void setCurrentInstance(PrimeRequestContext context, FacesContext facesContext) {
        if (context == null) {
            if (facesContext != null) {
                facesContext.getAttributes().remove(INSTANCE_KEY);
            }
        } else {
            facesContext.getAttributes().put(INSTANCE_KEY, context);
        }
    }

    public Map<String, Object> getCallbackParams() {
        HashMap callbackParams = (HashMap)this.context.getAttributes().get(CALLBACK_PARAMS_KEY);
        if (callbackParams == null) {
            callbackParams = new HashMap();
            this.context.getAttributes().put(CALLBACK_PARAMS_KEY, callbackParams);
        }
        return callbackParams;
    }

    public List<String> getInitScriptsToExecute() {
        ArrayList initScriptsToExecute = (ArrayList)this.context.getAttributes().get(EXECUTE_INIT_SCRIPTS_KEY);
        if (initScriptsToExecute == null) {
            initScriptsToExecute = new ArrayList(5);
            this.context.getAttributes().put(EXECUTE_INIT_SCRIPTS_KEY, initScriptsToExecute);
        }
        return initScriptsToExecute;
    }

    public List<String> getScriptsToExecute() {
        ArrayList scriptsToExecute = (ArrayList)this.context.getAttributes().get(EXECUTE_SCRIPTS_KEY);
        if (scriptsToExecute == null) {
            scriptsToExecute = new ArrayList();
            this.context.getAttributes().put(EXECUTE_SCRIPTS_KEY, scriptsToExecute);
        }
        return scriptsToExecute;
    }

    public WidgetBuilder getWidgetBuilder() {
        if (this.widgetBuilder == null) {
            this.widgetBuilder = new WidgetBuilder(this.context, this.getApplicationContext().getConfig());
        }
        return this.widgetBuilder;
    }

    public StyleClassBuilder getStyleClassBuilder() {
        if (this.styleClassBuilder == null) {
            this.styleClassBuilder = new StyleClassBuilder(this.context);
        }
        return this.styleClassBuilder;
    }

    public AjaxRequestBuilder getAjaxRequestBuilder() {
        if (this.ajaxRequestBuilder == null) {
            this.ajaxRequestBuilder = new AjaxRequestBuilder(this.context);
        }
        return this.ajaxRequestBuilder;
    }

    public CSVBuilder getCSVBuilder() {
        if (this.csvBuilder == null) {
            this.csvBuilder = new CSVBuilder(this.context);
        }
        return this.csvBuilder;
    }

    public PrimeApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = PrimeApplicationContext.getCurrentInstance(this.context);
        }
        return this.applicationContext;
    }

    public void release() {
        this.widgetBuilder = null;
        this.ajaxRequestBuilder = null;
        this.context = null;
        this.applicationContext = null;
    }

    public boolean isSecure() {
        if (this.secure == null) {
            Object request = this.context.getExternalContext().getRequest();
            if (request instanceof HttpServletRequest) {
                this.secure = ((HttpServletRequest)request).isSecure();
            } else {
                try {
                    Method method = request.getClass().getDeclaredMethod("isSecure", EMPTY_PARAMS);
                    this.secure = (Boolean)method.invoke(request, (Object[])null);
                }
                catch (Exception e) {
                    this.secure = false;
                }
            }
        }
        return this.secure;
    }

    public boolean isIgnoreAutoUpdate() {
        if (this.ignoreAutoUpdate == null) {
            Object ignoreAutoUpdateObject = this.context.getExternalContext().getRequestParameterMap().get("primefaces.ignoreautoupdate");
            this.ignoreAutoUpdate = null != ignoreAutoUpdateObject && "true".equals(ignoreAutoUpdateObject);
        }
        return this.ignoreAutoUpdate;
    }

    public void setIgnoreAutoUpdate(Boolean ignoreAutoUpdate) {
        this.ignoreAutoUpdate = ignoreAutoUpdate;
    }

    public boolean isRTL() {
        if (this.rtl == null) {
            String param = this.context.getExternalContext().getInitParameter("primefaces.DIR");
            if (param == null) {
                this.rtl = false;
            } else {
                ELContext elContext = this.context.getELContext();
                ExpressionFactory expressionFactory = this.context.getApplication().getExpressionFactory();
                ValueExpression expression = expressionFactory.createValueExpression(elContext, param, String.class);
                String expressionValue = (String)expression.getValue(elContext);
                this.rtl = "rtl".equalsIgnoreCase(expressionValue);
            }
        }
        return this.rtl;
    }

    public boolean isTouchable() {
        if (this.touchable == null) {
            this.touchable = this.evalBooleanExpression("primefaces.TOUCHABLE", true);
        }
        return this.touchable;
    }

    public boolean isFlex() {
        if (this.flex == null) {
            this.flex = this.evalBooleanExpression("primefaces.FLEX", false);
        }
        return this.flex;
    }

    private boolean evalBooleanExpression(String param, boolean defaultValueIfNull) {
        String paramValue = this.context.getExternalContext().getInitParameter(param);
        if (paramValue == null) {
            return defaultValueIfNull;
        }
        ELContext elContext = this.context.getELContext();
        ExpressionFactory expressionFactory = this.context.getApplication().getExpressionFactory();
        ValueExpression expression = expressionFactory.createValueExpression(elContext, paramValue, String.class);
        String expressionValue = (String)expression.getValue(elContext);
        return expressionValue == null || Boolean.parseBoolean(expressionValue);
    }
}

