/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.csp;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.servlet.http.HttpServletResponse;
import org.primefaces.PrimeFaces;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeFacesContext;
import org.primefaces.csp.CspState;
import org.primefaces.shaded.owasp.encoder.Encode;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;

public class CspPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private Lazy<Boolean> enabled = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().isCsp());
    private Lazy<String> customPolicy = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().getCspPolicy());

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        if (Boolean.FALSE.equals(this.enabled.get())) {
            return;
        }
        FacesContext context = event.getFacesContext();
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext.getResponse() instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
            CspState state = PrimeFacesContext.getCspState(context);
            String policy = LangUtils.isValueBlank(this.customPolicy.get()) ? "script-src 'self'" : this.customPolicy.get();
            response.addHeader("Content-Security-Policy", policy + " 'nonce-" + state.getNonce() + "'");
            String init = "PrimeFaces.csp.init('" + Encode.forJavaScript(state.getNonce()) + "');";
            PrimeFaces.current().executeInitScript(init);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

