/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.csp;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.context.ResponseWriterWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.primefaces.csp.CspState;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;

public class CspResponseWriter
extends ResponseWriterWrapper {
    static final Set<String> DOM_EVENTS = new HashSet<String>(Arrays.asList("onabort", "onafterprint", "onanimationend", "onanimationiteration", "onanimationstart", "onbeforeprint", "onbeforeunload", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "oncopy", "oncut", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onended", "onerror", "onfocus", "onfocusin", "onfocusout", "onfullscreenchange", "onfullscreenerror", "onhashchange", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmessage", "onmousedown", "onmouseenter", "onmouseleave", "onmousemove", "onmouseover", "onmouseout", "onmouseup", "onmousewheel", "onoffline", "ononline", "onopen", "onpagehide", "onpageshow", "onpaste", "onpause", "onplay", "onplaying", "onpopstate", "onprogress", "onratechange", "onresize", "onreset", "onscroll", "onsearch", "onseeked", "onseeking", "onselect", "onshow", "onstalled", "onstorage", "onsubmit", "onsuspend", "ontimeupdate", "ontoggle", "ontouchcancel", "ontouchend", "ontouchmove", "ontouchstart", "ontransitionend", "onunload", "onvolumechange", "onwaiting", "onwheel"));
    private ResponseWriter wrapped;
    private CspState cspState;
    private String lastElement;
    private String lastId;
    private String lastNonce;
    private Map<String, String> lastEvents;

    public CspResponseWriter(ResponseWriter wrapped, CspState cspState) {
        this.wrapped = wrapped;
        this.cspState = cspState;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.listenOnEndAttribute();
        this.lastElement = name;
        this.getWrapped().startElement(name, component);
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if ("nonce".equalsIgnoreCase(name) && value != null) {
            this.lastNonce = (String)value;
        } else if ("id".equalsIgnoreCase(name) && value != null) {
            this.lastId = (String)value;
        }
        String lowerCaseName = name.toLowerCase();
        if (lowerCaseName.startsWith("on") && DOM_EVENTS.contains(lowerCaseName)) {
            if (value != null) {
                if (this.lastEvents == null) {
                    this.lastEvents = new HashMap<String, String>(1);
                }
                this.lastEvents.put(name, (String)value);
            }
            return;
        }
        this.getWrapped().writeAttribute(name, value, property);
    }

    public void endElement(String name) throws IOException {
        this.listenOnEndAttribute();
        if ("body".equalsIgnoreCase(name)) {
            this.writeJavascriptHandlers();
        }
        this.getWrapped().endElement(name);
    }

    public void flush() throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().flush();
    }

    public void endDocument() throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().endDocument();
    }

    public void writeComment(Object comment) throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().writeComment(comment);
    }

    public void writeText(Object text, String property) throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().writeText(text, property);
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().writeText(text, component, property);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().writeText(text, off, len);
    }

    public void close() throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.listenOnEndAttribute();
        this.getWrapped().write(cbuf, off, len);
    }

    private void listenOnEndAttribute() throws IOException {
        if (this.lastElement == null) {
            return;
        }
        if ("script".equalsIgnoreCase(this.lastElement) && LangUtils.isValueBlank(this.lastNonce)) {
            this.getWrapped().writeAttribute("nonce", (Object)this.cspState.getNonce(), null);
        }
        if (this.lastEvents != null && !this.lastEvents.isEmpty()) {
            String id = this.lastId;
            if (LangUtils.isValueBlank(id)) {
                id = this.lastElement.toLowerCase() + "-" + UUID.randomUUID().toString();
                this.getWrapped().writeAttribute("id", (Object)id, null);
            }
            this.cspState.getEventHandlers().put(id, this.lastEvents);
        }
        this.reset();
    }

    public void reset() {
        this.lastElement = null;
        this.lastId = null;
        this.lastNonce = null;
        this.lastEvents = null;
    }

    void writeJavascriptHandlers() throws IOException {
        this.reset();
        if (this.cspState.getEventHandlers() == null || this.cspState.getEventHandlers().isEmpty()) {
            return;
        }
        this.startElement("script", null);
        StringBuilder javascriptBuilder = new StringBuilder(this.cspState.getEventHandlers().size() * 25);
        for (Map.Entry<String, Map<String, String>> elements : this.cspState.getEventHandlers().entrySet()) {
            String id = elements.getKey();
            for (Map.Entry<String, String> events : elements.getValue().entrySet()) {
                String event = events.getKey();
                String javascript = events.getValue();
                javascriptBuilder.append("PrimeFaces.csp.register('");
                javascriptBuilder.append(EscapeUtils.forJavaScript(id));
                javascriptBuilder.append("','");
                javascriptBuilder.append(event);
                javascriptBuilder.append("',function(event){");
                javascriptBuilder.append(javascript);
                javascriptBuilder.append("});");
            }
        }
        String javascript = javascriptBuilder.toString();
        this.writeText(javascript, null);
        this.endElement("script");
        this.cspState.getEventHandlers().clear();
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return this.getWrapped().cloneWithWriter(writer);
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }
}

