/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.csp;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.primefaces.util.LangUtils;

public class CspState {
    private FacesContext context;
    private Map<String, Map<String, String>> eventHandlers;
    private String nonce;

    public CspState(FacesContext context) {
        this.context = context;
        this.eventHandlers = new HashMap<String, Map<String, String>>(10);
    }

    public String getNonce() {
        if (this.nonce == null) {
            if (this.context.isPostback()) {
                this.nonce = (String)this.context.getExternalContext().getRequestParameterMap().get("primefaces.nonce");
                this.validate(this.nonce);
            } else {
                this.nonce = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        return this.nonce;
    }

    private void validate(String nonce) throws FacesException {
        if (LangUtils.isValueEmpty(nonce)) {
            throw new FacesException("Missing CSP nonce");
        }
        try {
            Base64.getDecoder().decode(nonce);
        }
        catch (Exception e) {
            throw new FacesException("Invalid CSP nonce", (Throwable)e);
        }
    }

    public Map<String, Map<String, String>> getEventHandlers() {
        return this.eventHandlers;
    }
}

