/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.expression.ClientIdSearchExpressionResolver;
import org.primefaces.expression.ComponentNotFoundException;
import org.primefaces.expression.MultiSearchExpressionResolver;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.expression.SearchExpressionResolverFactory;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public class SearchExpressionFacade {
    public static final char[] EXPRESSION_SEPARATORS = new char[]{',', ' '};
    private static final Logger LOGGER = Logger.getLogger(SearchExpressionFacade.class.getName());
    private static final String SHARED_EXPRESSION_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_EXPRESSION_BUFFER";
    private static final String SHARED_SPLIT_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_SPLIT_BUFFER_KEY";
    private static final String SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY = SearchExpressionFacade.class.getName() + ".SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY";

    private SearchExpressionFacade() {
    }

    public static List<UIComponent> resolveComponents(FacesContext context, UIComponent source, String expressions) {
        return SearchExpressionFacade.resolveComponents(context, source, expressions, Collections.emptySet());
    }

    public static List<UIComponent> resolveComponents(FacesContext context, UIComponent source, String expressions, Set<SearchExpressionHint> hints) {
        String[] splittedExpressions;
        ArrayList<UIComponent> components = new ArrayList<UIComponent>(5);
        if (!LangUtils.isValueBlank(expressions) && (splittedExpressions = SearchExpressionFacade.splitExpressions(context, source, expressions)) != null && splittedExpressions.length > 0) {
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (String splittedExpression : splittedExpressions) {
                UIComponent component;
                String expression = splittedExpression.trim();
                if (LangUtils.isValueBlank(expression)) continue;
                if (expression.contains("@") && expression.indexOf(separatorChar) != -1) {
                    components.addAll(SearchExpressionFacade.resolveComponentsByExpressionChain(context, source, expression, separatorChar, hints));
                    continue;
                }
                if (expression.contains("@")) {
                    SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, source, expression, components, hints);
                        continue;
                    }
                    component = resolver.resolveComponent(context, source, source, expression, hints);
                    if (component == null) {
                        if (hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) continue;
                        SearchExpressionFacade.cannotFindComponent(context, source, expression);
                        continue;
                    }
                    components.add(component);
                    continue;
                }
                ResolveComponentCallback callback = new ResolveComponentCallback();
                SearchExpressionFacade.resolveComponentById(source, expression, separatorChar, context, callback);
                component = callback.getComponent();
                if (component == null) {
                    if (hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) continue;
                    SearchExpressionFacade.cannotFindComponent(context, source, expression);
                    continue;
                }
                components.add(component);
            }
        }
        return components;
    }

    public static String resolveClientIds(FacesContext context, UIComponent source, String expressions) {
        return SearchExpressionFacade.resolveClientIds(context, source, expressions, Collections.emptySet());
    }

    public static String resolveClientIds(FacesContext context, UIComponent source, String expressions, Set<SearchExpressionHint> hints) {
        if (LangUtils.isValueBlank(expressions)) {
            if (hints.contains((Object)SearchExpressionHint.PARENT_FALLBACK)) {
                return source.getParent().getClientId(context);
            }
            return null;
        }
        String[] splittedExpressions = SearchExpressionFacade.splitExpressions(context, source, expressions);
        if (splittedExpressions != null && splittedExpressions.length > 0) {
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
            StringBuilder expressionsBuffer = SharedStringBuilder.get(context, SHARED_EXPRESSION_BUFFER_KEY);
            for (int i = 0; i < splittedExpressions.length; ++i) {
                String expression = splittedExpressions[i].trim();
                if (LangUtils.isValueBlank(expression)) continue;
                SearchExpressionFacade.validateExpression(context, source, expression, separatorChar);
                if (SearchExpressionFacade.isPassTroughExpression(expression)) {
                    if (expressionsBuffer.length() > 0) {
                        expressionsBuffer.append(" ");
                    }
                    expressionsBuffer.append(expression);
                    continue;
                }
                if (expression.contains("@") && expression.indexOf(separatorChar) != -1) {
                    String clientIds = SearchExpressionFacade.resolveClientIdsByExpressionChain(context, source, expression, separatorChar, hints);
                    if (LangUtils.isValueBlank(clientIds)) continue;
                    if (expressionsBuffer.length() > 0) {
                        expressionsBuffer.append(" ");
                    }
                    expressionsBuffer.append(clientIds);
                    continue;
                }
                if (expression.contains("@")) {
                    SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
                    if (resolver instanceof ClientIdSearchExpressionResolver) {
                        String clientIds = ((ClientIdSearchExpressionResolver)((Object)resolver)).resolveClientIds(context, source, source, expression, hints);
                        if (LangUtils.isValueBlank(clientIds)) continue;
                        if (expressionsBuffer.length() > 0) {
                            expressionsBuffer.append(" ");
                        }
                        expressionsBuffer.append(clientIds);
                        continue;
                    }
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ArrayList<UIComponent> result = new ArrayList<UIComponent>(5);
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, source, expression, result, hints);
                        for (int j = 0; j < result.size(); ++j) {
                            UIComponent component = result.get(j);
                            SearchExpressionFacade.validateRenderer(context, source, component, expression, hints);
                            if (expressionsBuffer.length() > 0) {
                                expressionsBuffer.append(" ");
                            }
                            expressionsBuffer.append(component.getClientId());
                        }
                        continue;
                    }
                    UIComponent component = resolver.resolveComponent(context, source, source, expression, hints);
                    if (component == null) {
                        if (hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) continue;
                        SearchExpressionFacade.cannotFindComponent(context, source, expression);
                        continue;
                    }
                    SearchExpressionFacade.validateRenderer(context, source, component, expression, hints);
                    if (expressionsBuffer.length() > 0) {
                        expressionsBuffer.append(" ");
                    }
                    expressionsBuffer.append(component.getClientId(context));
                    continue;
                }
                ResolveClientIdCallback callback = new ResolveClientIdCallback(source, hints, expression);
                SearchExpressionFacade.resolveComponentById(source, expression, separatorChar, context, callback);
                if (callback.getClientId() == null && !hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) {
                    SearchExpressionFacade.cannotFindComponent(context, source, expression);
                }
                if (callback.getClientId() == null) continue;
                if (expressionsBuffer.length() > 0) {
                    expressionsBuffer.append(" ");
                }
                expressionsBuffer.append(callback.getClientId());
            }
            String clientIds = expressionsBuffer.toString();
            if (!LangUtils.isValueBlank(clientIds)) {
                return clientIds;
            }
        }
        return null;
    }

    protected static void validateRenderer(FacesContext context, UIComponent source, UIComponent component, String expression, Set<SearchExpressionHint> hints) {
        if (hints.contains((Object)SearchExpressionHint.VALIDATE_RENDERER) && context.isProjectStage(ProjectStage.Development) && LangUtils.isValueBlank(component.getRendererType())) {
            LOGGER.log(Level.WARNING, "Can not update component \"{0}\" with id \"{1}\" without an attached renderer. Expression \"{2}\" referenced from \"{3}\"", new Object[]{component.getClass().getName(), component.getClientId(context), expression, source.getClientId(context)});
        }
    }

    public static String resolveClientId(FacesContext context, UIComponent source, String expression) {
        return SearchExpressionFacade.resolveClientId(context, source, expression, Collections.emptySet());
    }

    public static String resolveClientId(FacesContext context, UIComponent source, String expression, Set<SearchExpressionHint> hints) {
        UIComponent component;
        if (LangUtils.isValueBlank(expression)) {
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar);
        if (SearchExpressionFacade.isPassTroughExpression(expression)) {
            return expression;
        }
        if (expression.contains("@") && expression.indexOf(separatorChar) != -1) {
            component = SearchExpressionFacade.resolveComponentByExpressionChain(context, source, expression, separatorChar, hints);
        } else if (expression.contains("@")) {
            SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
            if (hints.contains((Object)SearchExpressionHint.RESOLVE_CLIENT_SIDE) && resolver instanceof ClientIdSearchExpressionResolver) {
                return ((ClientIdSearchExpressionResolver)((Object)resolver)).resolveClientIds(context, source, source, expression, hints);
            }
            component = resolver.resolveComponent(context, source, source, expression, hints);
        } else {
            ResolveClientIdCallback callback = new ResolveClientIdCallback(source, hints, expression);
            SearchExpressionFacade.resolveComponentById(source, expression, separatorChar, context, callback);
            if (callback.getClientId() == null && !hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) {
                SearchExpressionFacade.cannotFindComponent(context, source, expression);
            }
            return callback.getClientId();
        }
        if (component == null) {
            if (hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) {
                return null;
            }
            SearchExpressionFacade.cannotFindComponent(context, source, expression);
        }
        SearchExpressionFacade.validateRenderer(context, source, component, expression, hints);
        return component.getClientId(context);
    }

    public static UIComponent resolveComponent(FacesContext context, UIComponent source, String expression) {
        return SearchExpressionFacade.resolveComponent(context, source, expression, Collections.emptySet());
    }

    public static UIComponent resolveComponent(FacesContext context, UIComponent source, String expression, Set<SearchExpressionHint> hints) {
        UIComponent component;
        if (LangUtils.isValueBlank(expression)) {
            if (hints.contains((Object)SearchExpressionHint.PARENT_FALLBACK)) {
                return source.getParent();
            }
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar);
        if (expression.equals("@none")) {
            return null;
        }
        if (LangUtils.isValueBlank(expression)) {
            return null;
        }
        if (expression.contains("@") && expression.indexOf(separatorChar) != -1) {
            component = SearchExpressionFacade.resolveComponentByExpressionChain(context, source, expression, separatorChar, hints);
        } else if (expression.contains("@")) {
            SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
            component = resolver.resolveComponent(context, source, source, expression, hints);
        } else {
            ResolveComponentCallback callback = new ResolveComponentCallback();
            SearchExpressionFacade.resolveComponentById(source, expression, separatorChar, context, callback);
            component = callback.getComponent();
        }
        if (component == null && !hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) {
            SearchExpressionFacade.cannotFindComponent(context, source, expression);
        }
        return component;
    }

    private static UIComponent resolveComponentByExpressionChain(FacesContext context, UIComponent source, String expression, char separatorChar, Set<SearchExpressionHint> hints) {
        boolean startsWithSeperator;
        boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
        if (startsWithSeperator) {
            expression = expression.substring(1);
        }
        UIComponent last = source;
        String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
        if (subExpressions != null && subExpressions.length > 0) {
            for (int j = 0; j < subExpressions.length; ++j) {
                SearchExpressionResolver resolver;
                UIComponent temp;
                String subExpression = subExpressions[j].trim();
                if (LangUtils.isValueBlank(subExpression)) continue;
                if (startsWithSeperator && j == 0 && !subExpression.contains("@")) {
                    subExpression = separatorChar + subExpression;
                }
                if ((temp = (resolver = SearchExpressionResolverFactory.findResolver(subExpression)).resolveComponent(context, source, last, subExpression, hints)) == null) {
                    if (!hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) {
                        throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                    }
                    return null;
                }
                last = temp;
            }
        }
        return last;
    }

    private static void resolveComponentById(UIComponent source, String expression, char seperatorChar, FacesContext context, ContextCallback callback) {
        ComponentTraversalUtils.firstById(expression, source, seperatorChar, context, callback);
    }

    private static ArrayList<UIComponent> resolveComponentsByExpressionChain(FacesContext context, UIComponent source, String expression, char separatorChar, Set<SearchExpressionHint> hints) {
        boolean startsWithSeperator;
        boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
        if (startsWithSeperator) {
            expression = expression.substring(1);
        }
        ArrayList<UIComponent> lastComponents = new ArrayList<UIComponent>(5);
        lastComponents.add(source);
        String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
        if (subExpressions != null && subExpressions.length > 0) {
            ArrayList<UIComponent> tempComponents = new ArrayList<UIComponent>(5);
            for (int i = 0; i < subExpressions.length; ++i) {
                String subExpression = subExpressions[i].trim();
                if (LangUtils.isValueBlank(subExpression)) continue;
                if (startsWithSeperator && i == 0 && !subExpression.contains("@")) {
                    subExpression = separatorChar + subExpression;
                }
                SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(subExpression);
                tempComponents.clear();
                for (int j = 0; j < lastComponents.size(); ++j) {
                    UIComponent last = lastComponents.get(j);
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, last, subExpression, tempComponents, hints);
                        continue;
                    }
                    UIComponent temp = resolver.resolveComponent(context, source, last, subExpression, hints);
                    if (temp == null) {
                        if (hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) continue;
                        throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                    }
                    tempComponents.add(temp);
                }
                lastComponents.clear();
                lastComponents.addAll(tempComponents);
                tempComponents.clear();
            }
        }
        return lastComponents;
    }

    private static String resolveClientIdsByExpressionChain(FacesContext context, UIComponent source, String expression, char separatorChar, Set<SearchExpressionHint> hints) {
        boolean startsWithSeperator;
        boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
        if (startsWithSeperator) {
            expression = expression.substring(1);
        }
        ArrayList<UIComponent> lastComponents = new ArrayList<UIComponent>(5);
        lastComponents.add(source);
        StringBuilder clientIdsBuilder = null;
        String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
        if (subExpressions != null && subExpressions.length > 0) {
            ArrayList<UIComponent> tempComponents = new ArrayList<UIComponent>(5);
            for (int i = 0; i < subExpressions.length; ++i) {
                String subExpression = subExpressions[i].trim();
                if (LangUtils.isValueBlank(subExpression)) continue;
                if (startsWithSeperator && i == 0 && !subExpression.contains("@")) {
                    subExpression = separatorChar + subExpression;
                }
                SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(subExpression);
                tempComponents.clear();
                for (int j = 0; j < lastComponents.size(); ++j) {
                    UIComponent last = (UIComponent)lastComponents.get(j);
                    if (i == subExpressions.length - 1 && resolver instanceof ClientIdSearchExpressionResolver) {
                        String result = ((ClientIdSearchExpressionResolver)((Object)resolver)).resolveClientIds(context, source, last, subExpression, hints);
                        if (LangUtils.isValueBlank(result)) continue;
                        if (clientIdsBuilder == null) {
                            clientIdsBuilder = SharedStringBuilder.get(SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY);
                        } else if (clientIdsBuilder.length() > 0) {
                            clientIdsBuilder.append(" ");
                        }
                        clientIdsBuilder.append(result);
                        continue;
                    }
                    if (resolver instanceof MultiSearchExpressionResolver) {
                        ((MultiSearchExpressionResolver)((Object)resolver)).resolveComponents(context, source, last, subExpression, tempComponents, hints);
                        continue;
                    }
                    UIComponent temp = resolver.resolveComponent(context, source, last, subExpression, hints);
                    if (temp == null) {
                        if (hints.contains((Object)SearchExpressionHint.IGNORE_NO_RESULT)) continue;
                        throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                    }
                    tempComponents.add(temp);
                }
                lastComponents.clear();
                lastComponents.addAll(tempComponents);
                tempComponents.clear();
            }
        }
        if (clientIdsBuilder == null) {
            clientIdsBuilder = SharedStringBuilder.get(SHARED_CLIENT_ID_EXPRESSION_BUFFER_KEY);
            for (int i = 0; i < lastComponents.size(); ++i) {
                UIComponent result = (UIComponent)lastComponents.get(i);
                if (clientIdsBuilder.length() > 0) {
                    clientIdsBuilder.append(" ");
                }
                clientIdsBuilder.append(result.getClientId(context));
            }
        }
        return clientIdsBuilder.toString();
    }

    protected static void cannotFindComponent(FacesContext context, UIComponent source, String expression) {
        throw new ComponentNotFoundException("Cannot find component for expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
    }

    protected static String[] splitExpressions(FacesContext context, UIComponent source, String expressions) {
        String[] splittedExpressions = SearchExpressionFacade.split(context, expressions, EXPRESSION_SEPARATORS);
        if (splittedExpressions != null) {
            SearchExpressionFacade.validateExpressions(context, source, expressions, splittedExpressions);
        }
        return splittedExpressions;
    }

    protected static void validateExpression(FacesContext context, UIComponent source, String expression, char separatorChar) {
        if (context.isProjectStage(ProjectStage.Development)) {
            if (expression.startsWith(separatorChar + "@")) {
                throw new FacesException("A expression should not start with the separater char and a keyword. Expression: \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\"");
            }
            String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
            if (subExpressions != null && subExpressions.length > 1) {
                for (String subExpression : subExpressions) {
                    if (SearchExpressionFacade.isNestable(subExpression = subExpression.trim())) continue;
                    throw new FacesException("Subexpression \"" + subExpression + "\" in full expression \"" + expression + "\" from \"" + source.getClientId(context) + "\" can not be nested.");
                }
            }
        }
    }

    protected static void validateExpressions(FacesContext context, UIComponent source, String expressions, String[] splittedExpressions) {
        if (context.isProjectStage(ProjectStage.Development) && splittedExpressions.length > 1 && (expressions.contains("@none") || expressions.contains("@all"))) {
            throw new FacesException("It's not possible to use @none or @all combined with other expressions. Expressions: \"" + expressions + "\" referenced from \"" + source.getClientId(context) + "\"");
        }
    }

    public static String[] split(FacesContext context, String value, char ... separators) {
        if (LangUtils.isValueBlank(value)) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>(5);
        StringBuilder buffer = SharedStringBuilder.get(context, SHARED_SPLIT_BUFFER_KEY);
        int parenthesesCounter = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '(') {
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                boolean isSeparator = false;
                for (char separator : separators) {
                    if (c != separator) continue;
                    isSeparator = true;
                }
                if (isSeparator) {
                    tokens.add(buffer.toString());
                    buffer.delete(0, buffer.length());
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        tokens.add(buffer.toString());
        return tokens.toArray(new String[tokens.size()]);
    }

    protected static boolean isPassTroughExpression(String expression) {
        return expression.contains("@(");
    }

    protected static boolean isNestable(String expression) {
        return !expression.contains("@all") && !expression.contains("@none") && !expression.contains("@(");
    }

    static class ResolveComponentCallback
    implements ContextCallback {
        private UIComponent component;

        ResolveComponentCallback() {
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            this.component = target;
        }

        public UIComponent getComponent() {
            return this.component;
        }
    }

    static class ResolveClientIdCallback
    implements ContextCallback {
        private final UIComponent source;
        private final Set<SearchExpressionHint> hints;
        private final String expression;
        private String clientId;

        ResolveClientIdCallback(UIComponent source, Set<SearchExpressionHint> hints, String expression) {
            this.source = source;
            this.hints = hints;
            this.expression = expression;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            this.clientId = target.getClientId(context);
            SearchExpressionFacade.validateRenderer(context, this.source, target, this.expression, this.hints);
        }

        public String getClientId() {
            return this.clientId;
        }
    }
}

