/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.FaceletException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.primefaces.component.api.Widget;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.ComponentUtils;

public class SearchExpressionUtils {
    public static final Set<SearchExpressionHint> SET_NONE = Collections.unmodifiableSet(EnumSet.noneOf(SearchExpressionHint.class));
    public static final Set<SearchExpressionHint> SET_SKIP_UNRENDERED = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.SKIP_UNRENDERED));
    public static final Set<SearchExpressionHint> SET_RESOLVE_CLIENT_SIDE = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE));
    public static final Set<SearchExpressionHint> SET_PARENT_FALLBACK = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.PARENT_FALLBACK));
    public static final Set<SearchExpressionHint> SET_IGNORE_NO_RESULT = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.IGNORE_NO_RESULT));
    public static final Set<SearchExpressionHint> SET_VALIDATE_RENDERER = Collections.unmodifiableSet(EnumSet.of(SearchExpressionHint.VALIDATE_RENDERER));

    private SearchExpressionUtils() {
    }

    public static VisitContext createVisitContext(FacesContext context, Set<SearchExpressionHint> hints) {
        if (hints.contains((Object)SearchExpressionHint.SKIP_UNRENDERED)) {
            return VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        }
        return VisitContext.createVisitContext((FacesContext)context);
    }

    public static String resolveClientId(String expression, UIComponent source) {
        return SearchExpressionFacade.resolveClientId(FacesContext.getCurrentInstance(), source, expression);
    }

    public static UIComponent resolveComponent(String expression, UIComponent source) {
        return SearchExpressionFacade.resolveComponent(FacesContext.getCurrentInstance(), source, expression);
    }

    public static String resolveClientIds(String expressions, UIComponent source) {
        return SearchExpressionFacade.resolveClientIds(FacesContext.getCurrentInstance(), source, expressions);
    }

    public static String resolveWidgetVar(String expression, UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent resolvedComponent = SearchExpressionFacade.resolveComponent(context, component, expression);
        if (resolvedComponent instanceof Widget) {
            return ((Widget)resolvedComponent).resolveWidgetVar(context);
        }
        throw new FacesException("Component with clientId " + resolvedComponent.getClientId() + " is not a Widget");
    }

    public static String closestWidgetVar(UIComponent component) {
        Widget widget = ComponentTraversalUtils.closest(Widget.class, component);
        if (widget != null) {
            return widget.resolveWidgetVar(FacesContext.getCurrentInstance());
        }
        throw new FaceletException("Component with clientId " + component.getClientId() + " has no Widget as parent");
    }
}

