/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.expression.SearchExpressionResolver;

public class ChildExpressionResolver
implements SearchExpressionResolver {
    private static final Pattern PATTERN = Pattern.compile("@child\\((\\d+)\\)");

    @Override
    public UIComponent resolveComponent(FacesContext context, UIComponent source, UIComponent last, String expression, Set<SearchExpressionHint> hints) {
        Matcher matcher = PATTERN.matcher(expression);
        if (matcher.matches()) {
            int childNumber = Integer.parseInt(matcher.group(1));
            if (childNumber + 1 > last.getChildCount()) {
                throw new FacesException("Component with clientId \"" + last.getClientId(context) + "\" has fewer children as \"" + childNumber + "\". Expression: \"" + expression + "\"");
            }
            List list = last.getChildren();
            int count = 0;
            for (int i = 0; i < last.getChildCount(); ++i) {
                String className = ((UIComponent)list.get(i)).getClass().getName();
                if (!className.contains("UIInstructions") && !className.contains("UILeaf")) {
                    ++count;
                }
                if (count != childNumber + 1) continue;
                return (UIComponent)last.getChildren().get(childNumber);
            }
            if (count < childNumber) {
                throw new FacesException("Component with clientId \"" + last.getClientId(context) + "\" has fewer children as \"" + childNumber + "\". Expression: \"" + expression + "\"");
            }
        } else {
            throw new FacesException("Expression does not match following pattern @child(n). Expression: \"" + expression + "\"");
        }
        return null;
    }
}

