/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIColumn;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.columns.Columns;
import org.primefaces.expression.ClientIdSearchExpressionResolver;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.expression.SearchExpressionResolver;

public class RowExpressionResolver
implements SearchExpressionResolver,
ClientIdSearchExpressionResolver {
    private static final Pattern PATTERN = Pattern.compile("@row\\((\\d+)\\)");

    @Override
    public UIComponent resolveComponent(FacesContext context, UIComponent source, UIComponent last, String expression, Set<SearchExpressionHint> hints) {
        throw new FacesException("@row likely returns multiple components, therefore it's not supported in #resolveComponent... expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
    }

    @Override
    public String resolveClientIds(FacesContext context, UIComponent source, UIComponent last, String expression, Set<SearchExpressionHint> hints) {
        int row = this.validate(context, source, last, expression);
        UIData data = (UIData)last;
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        StringBuilder clientIds = new StringBuilder();
        for (UIComponent column : data.getChildren()) {
            if (column instanceof Columns) {
                List<DynamicColumn> dynamicColumns = ((Columns)column).getDynamicColumns();
                for (int i = 0; i < dynamicColumns.size(); ++i) {
                    DynamicColumn dynamicColumn = dynamicColumns.get(i);
                    for (UIComponent comp : column.getChildren()) {
                        if (clientIds.length() > 0) {
                            clientIds.append(" ");
                        }
                        clientIds.append(data.getClientId(context));
                        clientIds.append(separatorChar);
                        clientIds.append(row);
                        clientIds.append(separatorChar);
                        clientIds.append(dynamicColumn.getId());
                        clientIds.append(separatorChar);
                        clientIds.append(i);
                        clientIds.append(separatorChar);
                        clientIds.append(comp.getId());
                    }
                }
                continue;
            }
            if (!(column instanceof UIColumn)) continue;
            for (UIComponent cell : column.getChildren()) {
                if (clientIds.length() > 0) {
                    clientIds.append(" ");
                }
                clientIds.append(data.getClientId(context));
                clientIds.append(separatorChar);
                clientIds.append(row);
                clientIds.append(separatorChar);
                clientIds.append(cell.getId());
            }
        }
        return clientIds.toString();
    }

    protected int validate(FacesContext context, UIComponent source, UIComponent last, String expression) {
        if (!(last instanceof UIData)) {
            throw new FacesException("The last resolved component must be instance of UIData to support @row. Expression: \"" + expression + "\" referenced from \"" + last.getClientId(context) + "\".");
        }
        try {
            Matcher matcher = PATTERN.matcher(expression);
            if (matcher.matches()) {
                int row = Integer.parseInt(matcher.group(1));
                if (row < 0) {
                    throw new FacesException("Row number must be greater than 0. Expression: \"" + expression + "\"");
                }
                UIData data = (UIData)last;
                if (data.getRowCount() < row + 1) {
                    throw new FacesException("The row count of the target is lesser than the row number. Expression: \"" + expression + "\"");
                }
                return row;
            }
            throw new FacesException("Expression does not match following pattern @row(n). Expression: \"" + expression + "\"");
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @row(n). Expression: \"" + expression + "\"", (Throwable)e);
        }
    }
}

