/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import jakarta.faces.model.DataModel;
import jakarta.faces.model.DataModelEvent;
import jakarta.faces.model.DataModelListener;
import java.util.Collection;

public class CollectionDataModel<E>
extends DataModel<E> {
    private int index = -1;
    private Collection<E> wrapped;
    private E[] wrappedArray;

    public CollectionDataModel() {
        this(null);
    }

    public CollectionDataModel(Collection<E> collection) {
        this.setWrappedData(collection);
    }

    public int getRowCount() {
        if (this.wrappedArray == null) {
            return -1;
        }
        return this.wrappedArray.length;
    }

    public E getRowData() {
        if (this.wrappedArray == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("No next row available!");
        }
        return this.wrappedArray[this.index];
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int oldIndex = this.index;
        this.index = rowIndex;
        if (this.wrappedArray == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (oldIndex != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            for (DataModelListener listener : listeners) {
                if (listener == null) continue;
                listener.rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.wrapped;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.wrapped = null;
            this.wrappedArray = null;
            this.setRowIndex(-1);
        } else {
            this.wrapped = (Collection)data;
            this.wrappedArray = new Object[this.wrapped.size()];
            this.wrapped.toArray(this.wrappedArray);
            this.setRowIndex(0);
        }
    }

    public boolean isRowAvailable() {
        if (this.wrappedArray == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.wrappedArray.length;
    }
}

