/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.InputStream;
import java.io.Serializable;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.Lazy;
import org.primefaces.util.SerializableSupplier;

public class DefaultStreamedContent
implements StreamedContent,
Serializable {
    private Lazy<InputStream> stream;
    private String contentType;
    private String name;
    private String contentEncoding;
    private Integer contentLength;

    @Override
    public InputStream getStream() {
        InputStream result = null;
        if (this.stream != null) {
            result = this.stream.get();
        }
        return result;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public Integer getContentLength() {
        return this.contentLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final DefaultStreamedContent streamedContent = new DefaultStreamedContent();

        private Builder() {
        }

        public Builder stream(SerializableSupplier<InputStream> is) {
            this.streamedContent.stream = new Lazy<InputStream>(is);
            return this;
        }

        public Builder contentType(String contentType) {
            this.streamedContent.contentType = contentType;
            return this;
        }

        public Builder name(String name) {
            this.streamedContent.name = name;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.streamedContent.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLength(Integer contentLength) {
            this.streamedContent.contentLength = contentLength;
            return this;
        }

        public DefaultStreamedContent build() {
            return this.streamedContent;
        }
    }
}

