/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.ListDataModel;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModelIterator;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SortMeta;

public abstract class LazyDataModel<T>
extends ListDataModel<T>
implements SelectableDataModel<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int rowCount;
    private int pageSize;

    public abstract List<T> load(int var1, int var2, Map<String, SortMeta> var3, Map<String, FilterMeta> var4);

    @Override
    public T getRowData(String rowKey) {
        throw new UnsupportedOperationException(this.getMessage("getRowData(String rowKey) must be implemented by %s when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    @Override
    public String getRowKey(T object) {
        throw new UnsupportedOperationException(this.getMessage("getRowKey(T object) must be implemented by %s when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    private String getMessage(String format) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = facesContext.getViewRoot().getViewId();
        UIComponent component = UIComponent.getCurrentComponent((FacesContext)facesContext);
        String clientId = component == null ? "<unknown>" : component.getClientId(facesContext);
        return String.format(format, this.getClass().getName(), clientId, viewId);
    }

    public Iterator<T> iterator() {
        return new LazyDataModelIterator(this);
    }

    public Iterator<T> iterator(Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        return new LazyDataModelIterator(this, sortBy, filterBy);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex != -1) {
            rowIndex = this.pageSize == 0 ? -1 : (rowIndex %= this.pageSize);
        }
        super.setRowIndex(rowIndex);
    }

    public List<T> getWrappedData() {
        return (List)super.getWrappedData();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }
}

