/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;

public class LazyDataModelIterator<T>
implements Iterator<T> {
    private LazyDataModel<T> model;
    private int index;
    private Map<Integer, List<T>> pages;
    private Map<String, SortMeta> sortBy;
    private Map<String, FilterMeta> filterBy;

    LazyDataModelIterator(LazyDataModel<T> model) {
        this.model = model;
        this.index = -1;
        this.pages = new HashMap<Integer, List<T>>();
        this.sortBy = Collections.emptyMap();
        this.filterBy = Collections.emptyMap();
    }

    LazyDataModelIterator(LazyDataModel<T> model, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        this(model);
        if (sortBy != null) {
            this.sortBy = sortBy;
        }
        if (filterBy != null) {
            this.filterBy = filterBy;
        }
    }

    @Override
    public boolean hasNext() {
        int pageIndex;
        int nextIndex = this.index + 1;
        int pageNo = nextIndex / this.model.getPageSize();
        if (!this.pages.containsKey(pageNo)) {
            List<T> page = this.model.load(nextIndex, this.model.getPageSize(), this.sortBy, this.filterBy);
            if (page == null || page.isEmpty()) {
                return false;
            }
            this.pages.remove(pageNo - 1);
            this.pages.put(pageNo, page);
        }
        return (pageIndex = nextIndex % this.model.getPageSize()) < this.pages.get(pageNo).size();
    }

    @Override
    public T next() {
        ++this.index;
        int pageNo = this.index / this.model.getPageSize();
        int pageIndex = this.index % this.model.getPageSize();
        List<T> page = this.pages.get(pageNo);
        if (page == null || pageIndex >= page.size()) {
            throw new NoSuchElementException();
        }
        return page.get(pageIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

