/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.faces.render.Renderer;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.primefaces.clientwindow.PrimeClientWindow;
import org.primefaces.clientwindow.PrimeClientWindowUtils;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;

public class HeadRenderer
extends Renderer {
    private static final String LIBRARY = "primefaces";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent middle;
        String theme;
        String themeParamValue;
        ResponseWriter writer = context.getResponseWriter();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        boolean csvEnabled = applicationContext.getConfig().isClientSideValidationEnabled();
        writer.startElement("head", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        UIComponent first = component.getFacet("first");
        if (ComponentUtils.shouldRenderFacet(first)) {
            first.encodeAll(context);
        }
        if ((themeParamValue = applicationContext.getConfig().getTheme()) != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        } else {
            theme = "saga";
        }
        if (theme != null && !"none".equals(theme)) {
            this.encodeCSS(context, "primefaces-" + theme, "theme.css");
        }
        if (applicationContext.getConfig().isPrimeIconsEnabled()) {
            this.encodeCSS(context, LIBRARY, "primeicons/primeicons.css");
        }
        if (applicationContext.getConfig().isFontAwesomeEnabled()) {
            this.encodeCSS(context, LIBRARY, "fa/font-awesome.css");
        }
        if (ComponentUtils.shouldRenderFacet(middle = component.getFacet("middle"))) {
            middle.encodeAll(context);
        }
        UIViewRoot viewRoot = context.getViewRoot();
        List resources = viewRoot.getComponentResources(context, "head");
        for (int i = 0; i < resources.size(); ++i) {
            UIComponent resource = (UIComponent)resources.get(i);
            resource.encodeAll(context);
        }
        if (csvEnabled) {
            this.encodeValidationResources(context, applicationContext.getConfig().isBeanValidationEnabled());
        }
        if (applicationContext.getConfig().isClientSideLocalizationEnabled()) {
            Locale locale = LocaleUtils.getCurrentLocale(context);
            this.encodeJS(context, LIBRARY, "locales/locale-" + locale.getLanguage() + ".js");
        }
        this.encodeSettingScripts(context, applicationContext, requestContext, writer, csvEnabled);
        this.encodeInitScripts(writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent last = component.getFacet("last");
        if (ComponentUtils.shouldRenderFacet(last)) {
            last.encodeAll(context);
        }
        writer.endElement("head");
    }

    protected void encodeCSS(FacesContext context, String library, String resource) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ExternalContext externalContext = context.getExternalContext();
        Resource cssResource = context.getApplication().getResourceHandler().createResource(resource, library);
        if (cssResource == null) {
            throw new FacesException("Error loading CSS, cannot find \"" + resource + "\" resource of \"" + library + "\" library");
        }
        writer.startElement("link", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)externalContext.encodeResourceURL(cssResource.getRequestPath()), null);
        writer.endElement("link");
    }

    protected void encodeJS(FacesContext context, String library, String script) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ExternalContext externalContext = context.getExternalContext();
        Resource resource = context.getApplication().getResourceHandler().createResource(script, library);
        if (resource == null) {
            throw new FacesException("Error loading JavaScript, cannot find \"" + script + "\" resource of \"" + library + "\" library");
        }
        writer.startElement("script", null);
        writer.writeAttribute("src", (Object)externalContext.encodeResourceURL(resource.getRequestPath()), null);
        writer.endElement("script");
    }

    protected void encodeValidationResources(FacesContext context, boolean beanValidationEnabled) throws IOException {
        this.encodeJS(context, LIBRARY, "validation/validation.js");
        if (beanValidationEnabled) {
            this.encodeJS(context, LIBRARY, "validation/validation.bv.js");
        }
    }

    protected void encodeSettingScripts(FacesContext context, PrimeApplicationContext applicationContext, PrimeRequestContext requestContext, ResponseWriter writer, boolean csvEnabled) throws IOException {
        ClientWindow clientWindow;
        ProjectStage projectStage = context.getApplication().getProjectStage();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("if(window.PrimeFaces){");
        writer.write("PrimeFaces.settings.locale='" + LocaleUtils.getCurrentLocale(context) + "';");
        writer.write("PrimeFaces.settings.viewId='" + context.getViewRoot().getViewId() + "';");
        writer.write("PrimeFaces.settings.contextPath='" + context.getExternalContext().getRequestContextPath() + "';");
        writer.write("PrimeFaces.settings.cookiesSecure=" + (requestContext.isSecure() && applicationContext.getConfig().isCookiesSecure()) + ";");
        if (applicationContext.getConfig().getCookiesSameSite() != null) {
            writer.write("PrimeFaces.settings.cookiesSameSite='" + applicationContext.getConfig().getCookiesSameSite() + "';");
        }
        if (csvEnabled) {
            writer.write("PrimeFaces.settings.validateEmptyFields=" + applicationContext.getConfig().isValidateEmptyFields() + ";");
            writer.write("PrimeFaces.settings.considerEmptyStringNull=" + applicationContext.getConfig().isInterpretEmptyStringAsNull() + ";");
        }
        if (applicationContext.getConfig().isLegacyWidgetNamespace()) {
            writer.write("PrimeFaces.settings.legacyWidgetNamespace=true;");
        }
        if (applicationContext.getConfig().isEarlyPostParamEvaluation()) {
            writer.write("PrimeFaces.settings.earlyPostParamEvaluation=true;");
        }
        if (applicationContext.getConfig().isPartialSubmitEnabled()) {
            writer.write("PrimeFaces.settings.partialSubmit=true;");
        }
        if (projectStage != ProjectStage.Production) {
            writer.write("PrimeFaces.settings.projectStage='" + projectStage.toString() + "';");
        }
        if (applicationContext.getEnvironment().isAtLeastJsf22() && context.getExternalContext().getClientWindow() != null && (clientWindow = context.getExternalContext().getClientWindow()) instanceof PrimeClientWindow) {
            boolean initialRedirect = false;
            Object cookie = PrimeClientWindowUtils.getInitialRedirectCookie(context, clientWindow.getId());
            if (cookie instanceof Cookie) {
                Cookie servletCookie = (Cookie)cookie;
                initialRedirect = true;
                servletCookie.setMaxAge(0);
                ((HttpServletResponse)context.getExternalContext().getResponse()).addCookie(servletCookie);
            }
            writer.write(String.format("PrimeFaces.clientwindow.init('%s', %s);", PrimeClientWindowUtils.secureWindowId(clientWindow.getId()), initialRedirect));
        }
        writer.write("}");
        writer.endElement("script");
    }

    protected void encodeInitScripts(ResponseWriter writer) throws IOException {
        List<String> scripts = PrimeRequestContext.getCurrentInstance().getInitScriptsToExecute();
        if (!scripts.isEmpty()) {
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            boolean moveScriptsToBottom = PrimeRequestContext.getCurrentInstance().getApplicationContext().getConfig().isMoveScriptsToBottom();
            if (!moveScriptsToBottom) {
                writer.write("$(function(){");
            }
            for (int i = 0; i < scripts.size(); ++i) {
                writer.write(scripts.get(i));
                writer.write(59);
            }
            if (!moveScriptsToBottom) {
                writer.write("});");
            }
            writer.endElement("script");
        }
    }
}

