/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.behavior.confirm.ConfirmBehavior;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.component.api.DialogReturnAware;
import org.primefaces.component.api.MenuItemAware;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.divider.Divider;
import org.primefaces.event.MenuActionEvent;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuGroup;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.ComponentTraversalUtils;

public class MenuItemAwareRenderer
extends OutcomeTargetRenderer {
    private static final String SEPARATOR = "_";

    public void decode(FacesContext context, UIComponent component) {
        this.decodeDynamicMenuItem(context, component);
    }

    protected void encodeOnClick(FacesContext context, UIComponent source, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.setConfirmationScript(context, menuitem);
        String onclick = menuitem.getOnclick();
        if (menuitem.getUrl() != null || menuitem.getOutcome() != null) {
            String targetURL = this.getTargetURL(context, (UIOutcomeTarget)((Object)menuitem));
            writer.writeAttribute("href", (Object)targetURL, null);
            if (menuitem.getTarget() != null) {
                writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
            }
        } else {
            String command;
            writer.writeAttribute("href", (Object)"#", null);
            UIForm form = ComponentTraversalUtils.closestForm(context, source);
            if (form == null) {
                throw new FacesException("MenuItem must be inside a form element");
            }
            if (menuitem.isDynamic()) {
                String menuClientId = source.getClientId(context);
                Map<String, List<String>> params = menuitem.getParams();
                if (params == null) {
                    params = new LinkedHashMap<String, List<String>>();
                }
                List<String> idParams = Collections.singletonList(menuitem.getId());
                params.put(menuClientId + "_menuid", idParams);
                command = menuitem.isAjax() ? this.buildAjaxRequest(context, source, (AjaxSource)((Object)menuitem), form, params) : this.buildNonAjaxRequest(context, source, (UIComponent)form, menuClientId, params, true);
            } else {
                command = menuitem.isAjax() ? this.buildAjaxRequest(context, (UIComponent)((AjaxSource)((UIComponent)menuitem)), form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, (UIComponent)form, ((UIComponent)menuitem).getClientId(context), true);
            }
            String string = onclick = onclick == null ? command : onclick + ";" + command;
        }
        if (onclick != null) {
            if (menuitem.requiresConfirmation()) {
                writer.writeAttribute("data-pfconfirmcommand", (Object)onclick, null);
                writer.writeAttribute("onclick", (Object)menuitem.getConfirmationScript(), "onclick");
            } else {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
        }
        if (menuitem instanceof DialogReturnAware) {
            ArrayList<ClientBehaviorContext.Parameter> behaviorParams = new ArrayList<ClientBehaviorContext.Parameter>(1);
            behaviorParams.add(new ClientBehaviorContext.Parameter("CLIENT_BEHAVIOR_RENDERING_MODE", (Object)ClientBehaviorRenderingMode.UNOBSTRUSIVE));
            String dialogReturnBehavior = this.getEventBehaviors(context, (ClientBehaviorHolder)menuitem, "dialogReturn", behaviorParams);
            if (dialogReturnBehavior != null) {
                writer.writeAttribute("data-dialogreturn", (Object)dialogReturnBehavior, null);
            }
        }
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        String styleClass;
        if (!separator.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        if (separator instanceof Divider) {
            String layout = ((Divider)separator).getLayout();
            String align = ((Divider)separator).getAlign();
            String type = ((Divider)separator).getType();
            boolean isHorizontal = "horizontal".equals(layout);
            boolean isVertical = "vertical".equals(layout);
            styleClass = this.getStyleClassBuilder(context).add("ui-divider ui-widget").add(separator.getStyleClass()).add(isHorizontal, "ui-divider-horizontal").add(isVertical, "ui-divider-vertical").add("solid".equals(type), "ui-divider-solid").add("dashed".equals(type), "ui-divider-dashed").add("dotted".equals(type), "ui-divider-dotted").add(isHorizontal && (align == null || "left".equals(align)), "ui-divider-left").add(isHorizontal && "right".equals(align), "ui-divider-right").add(isHorizontal && "center".equals(align) || isVertical && (align == null || "center".equals(align)), "ui-divider-center").add(isVertical && "top".equals(align), "ui-divider-top").add(isVertical && "bottom".equals(align), "ui-divider-bottom").build();
        } else {
            styleClass = this.getStyleClassBuilder(context).add("ui-divider ui-widget").add("ui-divider-horizontal").add("ui-divider-solid").add(separator.getStyleClass()).build();
        }
        writer.startElement("li", null);
        writer.writeAttribute("role", (Object)"separator", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    protected void setConfirmationScript(FacesContext context, MenuItem item) {
        if (item instanceof ClientBehaviorHolder) {
            List clickBehaviors;
            Map behaviors = ((ClientBehaviorHolder)item).getClientBehaviors();
            List list = clickBehaviors = behaviors == null ? null : (List)behaviors.get("click");
            if (clickBehaviors != null && !clickBehaviors.isEmpty()) {
                for (int i = 0; i < clickBehaviors.size(); ++i) {
                    ClientBehavior clientBehavior = (ClientBehavior)clickBehaviors.get(i);
                    if (!(clientBehavior instanceof ConfirmBehavior)) continue;
                    ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)item), (String)"click", (String)item.getClientId(), Collections.emptyList());
                    clientBehavior.getScript(cbc);
                    break;
                }
            }
        }
    }

    protected MenuItem findMenuitem(List<MenuElement> elements, String id) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        String[] paths = id.split(SEPARATOR);
        if (paths.length == 0) {
            return null;
        }
        int childIndex = Integer.parseInt(paths[0]);
        if (childIndex >= elements.size()) {
            return null;
        }
        MenuElement childElement = elements.get(childIndex);
        if (paths.length == 1) {
            return (MenuItem)childElement;
        }
        String relativeIndex = id.substring(id.indexOf(SEPARATOR) + 1);
        return this.findMenuitem(((MenuGroup)childElement).getElements(), relativeIndex);
    }

    protected boolean decodeDynamicMenuItem(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String menuid = (String)params.get(clientId + "_menuid");
        if (menuid != null) {
            MenuItem menuitem = this.findMenuitem(((MenuItemAware)component).getElements(), menuid);
            MenuActionEvent event = new MenuActionEvent(component, menuitem);
            if (menuitem.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            component.queueEvent((FacesEvent)event);
        }
        return menuid != null;
    }
}

