/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import jakarta.faces.application.FacesMessage;
import org.primefaces.component.api.UINotification;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.MessageFactory;

public class UINotificationRenderer
extends CoreRenderer {
    protected boolean shouldRender(UINotification component, FacesMessage message, String severityName) {
        String severityLevel = component.getSeverity();
        return !(message.isRendered() && !component.isRedisplay() || severityLevel != null && !severityLevel.contains(severityName));
    }

    protected String getSeverityName(FacesMessage message) {
        int ordinal = message.getSeverity().getOrdinal();
        String severity = null;
        if (ordinal == FacesMessage.SEVERITY_INFO.getOrdinal()) {
            severity = "info";
        } else if (ordinal == FacesMessage.SEVERITY_ERROR.getOrdinal()) {
            severity = "error";
        } else if (ordinal == FacesMessage.SEVERITY_WARN.getOrdinal()) {
            severity = "warn";
        } else if (ordinal == FacesMessage.SEVERITY_FATAL.getOrdinal()) {
            severity = "fatal";
        }
        return severity;
    }

    protected String getSeverityText(FacesMessage message) {
        int ordinal = message.getSeverity().getOrdinal();
        String severity = null;
        if (ordinal == FacesMessage.SEVERITY_INFO.getOrdinal()) {
            severity = MessageFactory.getMessage("primefaces.messages.aria.INFO", new Object[0]);
        } else if (ordinal == FacesMessage.SEVERITY_ERROR.getOrdinal()) {
            severity = MessageFactory.getMessage("primefaces.messages.aria.ERROR", new Object[0]);
        } else if (ordinal == FacesMessage.SEVERITY_WARN.getOrdinal()) {
            severity = MessageFactory.getMessage("primefaces.messages.aria.WARN", new Object[0]);
        } else if (ordinal == FacesMessage.SEVERITY_FATAL.getOrdinal()) {
            severity = MessageFactory.getMessage("primefaces.messages.aria.FATAL", new Object[0]);
        }
        return severity;
    }

    protected String getClientSideSeverity(String severity) {
        if (severity == null) {
            return "all,error";
        }
        return severity;
    }
}

