/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.List;
import org.primefaces.util.LangUtils;

public class BeanUtils {
    private static final List<Class<?>> PRIMITIVES = LangUtils.unmodifiableList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class);

    private BeanUtils() {
    }

    public static boolean isBean(Class<?> valueClass) {
        if (valueClass.isArray()) {
            return BeanUtils.isBean(valueClass.getComponentType());
        }
        if (valueClass.isPrimitive()) {
            return false;
        }
        return !PRIMITIVES.contains(valueClass);
    }

    public static boolean isBean(Object value) {
        if (value instanceof Boolean || value instanceof String || value instanceof Number) {
            return false;
        }
        if (value.getClass().isArray()) {
            return BeanUtils.isBean(value.getClass().getComponentType());
        }
        return !value.getClass().isPrimitive();
    }
}

