/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ComponentTraversalUtils {
    private ComponentTraversalUtils() {
    }

    public static <T> T closest(Class<T> type, UIComponent base) {
        for (UIComponent parent = base.getParent(); parent != null; parent = parent.getParent()) {
            if (!type.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        return null;
    }

    public static <T> T first(Class<T> type, UIComponent base) {
        Object result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            UIComponent kid = (UIComponent)kids.next();
            if (type.isAssignableFrom(kid.getClass())) {
                result = kid;
                break;
            }
            result = ComponentTraversalUtils.first(type, kid);
            if (result == null) continue;
            break;
        }
        return (T)result;
    }

    public static <T> List<T> children(Class<T> type, UIComponent base) {
        ArrayList<UIComponent> result = new ArrayList<UIComponent>();
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!type.isAssignableFrom(kid.getClass())) continue;
            result.add(kid);
        }
        return result;
    }

    public static void withId(String id, UIComponent base, List<UIComponent> components) {
        if (id.equals(base.getId())) {
            components.add(base);
        }
        if (base.getFacetCount() > 0) {
            for (UIComponent facet : base.getFacets().values()) {
                ComponentTraversalUtils.withId(id, facet, components);
            }
        }
        if (base.getChildCount() > 0) {
            int childCount = base.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)base.getChildren().get(i);
                ComponentTraversalUtils.withId(id, child, components);
            }
        }
    }

    public static UIComponent firstWithId(String id, UIComponent base) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            UIComponent kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ComponentTraversalUtils.firstWithId(id, kid);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static void firstById(String id, UIComponent base, char separatorChar, FacesContext context, ContextCallback callback) {
        UIComponent component = base.findComponent(id);
        if (component == null) {
            String tempExpression = id;
            if (tempExpression.charAt(0) == separatorChar) {
                tempExpression = tempExpression.substring(1);
            }
            context.getViewRoot().invokeOnComponent(context, tempExpression, callback);
        } else {
            callback.invokeContextCallback(context, component);
        }
    }

    public static UIForm closestForm(FacesContext context, UIComponent component) {
        return ComponentTraversalUtils.closest(UIForm.class, component);
    }

    public static UniqueIdVendor closestUniqueIdVendor(UIComponent component) {
        return ComponentTraversalUtils.closest(UniqueIdVendor.class, component);
    }

    public static UIComponent closestNamingContainer(UIComponent component) {
        return (UIComponent)ComponentTraversalUtils.closest(NamingContainer.class, component);
    }
}

