/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.Lazy;
import org.primefaces.util.LimitedSizeHashMap;
import org.primefaces.util.ResourceUtils;
import org.primefaces.util.SharedStringBuilder;

public class DynamicContentSrcBuilder {
    private static final String SB_BUILD_STREAMING = DynamicContentSrcBuilder.class.getName() + "#buildStreaming";

    private DynamicContentSrcBuilder() {
    }

    public static String build(FacesContext context, UIComponent component, ValueExpression ve, Lazy<Object> value, boolean cache, boolean stream) {
        if (ve == null && value.get() == null) {
            return "";
        }
        Class<?> type = null;
        if (ve != null) {
            type = ve.getExpectedType();
        }
        if ((type == null || type == Object.class) && ve != null) {
            try {
                type = ve.getType(context.getELContext());
            }
            catch (ELException eLException) {
                // empty catch block
            }
        }
        if ((type == null || type == Object.class) && value.get() != null) {
            type = value.get().getClass();
        }
        if (type == null) {
            return "";
        }
        if (String.class.isAssignableFrom(type)) {
            String src = ResourceUtils.getResourceURL(context, (String)value.get());
            return DynamicContentSrcBuilder.encodeResourceURL(context, src, cache);
        }
        if (StreamedContent.class.isAssignableFrom(type)) {
            if (stream) {
                ValueExpression extractedVE = ValueExpressionAnalyzer.getExpression(context.getELContext(), ve);
                return DynamicContentSrcBuilder.buildStreaming(context, component, extractedVE, cache);
            }
            StreamedContent streamedContent = (StreamedContent)value.get();
            return DynamicContentSrcBuilder.buildBase64(context, streamedContent.getStream(), streamedContent.getContentType());
        }
        if (byte[].class.isAssignableFrom(type)) {
            if (stream) {
                ValueExpression extractedVE = ValueExpressionAnalyzer.getExpression(context.getELContext(), ve);
                return DynamicContentSrcBuilder.buildStreaming(context, component, extractedVE, cache);
            }
            return DynamicContentSrcBuilder.buildBase64(context, (byte[])value.get());
        }
        if (InputStream.class.isAssignableFrom(type)) {
            if (stream) {
                ValueExpression extractedVE = ValueExpressionAnalyzer.getExpression(context.getELContext(), ve);
                return DynamicContentSrcBuilder.buildStreaming(context, component, extractedVE, cache);
            }
            return DynamicContentSrcBuilder.buildBase64(context, (InputStream)value.get());
        }
        return "";
    }

    public static String buildStreaming(FacesContext context, ValueExpression valueExpression, boolean cache) {
        return DynamicContentSrcBuilder.buildStreaming(context, null, valueExpression, cache);
    }

    public static String buildStreaming(FacesContext context, UIComponent component, ValueExpression valueExpression, boolean cache) {
        Resource resource = context.getApplication().getResourceHandler().createResource("dynamiccontent.properties", "primefaces", "text/plain");
        String resourcePath = resource.getRequestPath();
        Map session = context.getExternalContext().getSessionMap();
        LimitedSizeHashMap<String, String> dynamicResourcesMapping = (LimitedSizeHashMap<String, String>)session.get("primefaces.dynamicResourcesMapping");
        if (dynamicResourcesMapping == null) {
            dynamicResourcesMapping = new LimitedSizeHashMap<String, String>(200);
            session.put("primefaces.dynamicResourcesMapping", dynamicResourcesMapping);
        }
        String expressionString = valueExpression.getExpressionString();
        String resourceKey = DynamicContentSrcBuilder.md5(expressionString);
        dynamicResourcesMapping.put(resourceKey, expressionString);
        try {
            StringBuilder builder = SharedStringBuilder.get(context, SB_BUILD_STREAMING);
            builder.append(resourcePath).append("&").append("pfdrid").append("=").append(URLEncoder.encode(resourceKey, "UTF-8")).append("&").append("pfdrt").append("=").append(DynamicContentType.STREAMED_CONTENT.toString());
            if (component != null) {
                for (int i = 0; i < component.getChildCount(); ++i) {
                    UIParameter param;
                    UIComponent child = (UIComponent)component.getChildren().get(i);
                    if (!(child instanceof UIParameter) || (param = (UIParameter)child).isDisable()) continue;
                    Object paramValue = param.getValue();
                    builder.append("&").append(param.getName()).append("=");
                    if (paramValue == null) continue;
                    builder.append(URLEncoder.encode(paramValue.toString(), "UTF-8"));
                }
            }
            return DynamicContentSrcBuilder.encodeResourceURL(context, builder.toString(), cache);
        }
        catch (UnsupportedEncodingException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public static String buildBase64(FacesContext context, InputStream is) {
        return DynamicContentSrcBuilder.buildBase64(context, DynamicContentSrcBuilder.toByteArray(is), null);
    }

    public static String buildBase64(FacesContext context, InputStream is, String contentType) {
        return DynamicContentSrcBuilder.buildBase64(context, DynamicContentSrcBuilder.toByteArray(is), contentType);
    }

    public static String buildBase64(FacesContext context, byte[] bytes) {
        return DynamicContentSrcBuilder.buildBase64(context, bytes, null);
    }

    public static String buildBase64(FacesContext context, byte[] bytes, String contentType) {
        String base64 = Base64.getEncoder().withoutPadding().encodeToString(bytes);
        if (contentType == null) {
            if (base64.startsWith("R0lGOD")) {
                contentType = "image/gif";
            } else if (base64.startsWith("iVBORw")) {
                contentType = "image/png";
            } else if (base64.startsWith("/9j/")) {
                contentType = "image/jpeg";
            }
        }
        return "data:" + contentType + ";base64," + base64;
    }

    protected static String encodeResourceURL(FacesContext context, String src, boolean cache) {
        return context.getExternalContext().encodeResourceURL(ResourceUtils.appendCacheBuster(src, cache));
    }

    protected static byte[] toByteArray(InputStream is) {
        byte[] byArray;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FacesException("Could not read InputStream to byte[]", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    protected static String md5(String input) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new FacesException((Throwable)ex);
        }
        byte[] bytes = messageDigest.digest(input.getBytes());
        return new BigInteger(1, bytes).toString(16);
    }
}

