/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.regex.Pattern;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.primefaces.util.LangUtils;

public class HtmlSanitizer {
    private static final PolicyFactory HTML_IMAGES_SANITIZER = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"data", "http", "https"}).allowElements(new String[]{"img"}).allowAttributes(new String[]{"src"}).matching(Pattern.compile("^(data:image/(gif|png|jpeg)[,;]|http|https|mailto|//).+", 2)).onElements(new String[]{"img"}).toFactory();
    private static final PolicyFactory HTML_LINKS_SANITIZER = Sanitizers.LINKS.and(new HtmlPolicyBuilder().allowElements(new String[]{"a"}).allowAttributes(new String[]{"target"}).onElements(new String[]{"a"}).toFactory());
    private static final PolicyFactory HTML_STYLES_SANITIZER = Sanitizers.STYLES.and(new HtmlPolicyBuilder().allowElements(new String[]{"span", "li", "p"}).allowAttributes(new String[]{"class"}).onElements(new String[]{"span", "li", "p"}).toFactory());
    private static final PolicyFactory HTML_DENY_ALL_SANITIZER = new HtmlPolicyBuilder().toFactory();

    private HtmlSanitizer() {
    }

    public static String sanitizeHtml(String value, boolean allowBlocks, boolean allowFormatting, boolean allowLinks, boolean allowStyles, boolean allowImages) {
        if (LangUtils.isValueBlank(value)) {
            return value;
        }
        PolicyFactory sanitizer = HTML_DENY_ALL_SANITIZER;
        if (allowBlocks) {
            sanitizer = sanitizer.and(Sanitizers.BLOCKS);
        }
        if (allowFormatting) {
            sanitizer = sanitizer.and(Sanitizers.FORMATTING);
        }
        if (allowLinks) {
            sanitizer = sanitizer.and(HTML_LINKS_SANITIZER);
        }
        if (allowStyles) {
            sanitizer = sanitizer.and(HTML_STYLES_SANITIZER);
        }
        if (allowImages) {
            sanitizer = sanitizer.and(HTML_IMAGES_SANITIZER);
        }
        return sanitizer.sanitize(value);
    }
}

