/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.FacesException;
import jakarta.xml.bind.DatatypeConverter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class LangUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Pattern CAPITAL_CASE = Pattern.compile("(?<=.)(?=\\p{Lu})");

    private LangUtils() {
    }

    public static boolean isValueEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean isValueBlank(String str) {
        if (str == null) {
            return true;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String value) {
        return !LangUtils.isValueBlank(value);
    }

    public static int countMatches(String str, char ch) {
        if (LangUtils.isValueEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static boolean contains(Object[] array, Object object) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> Set<T> concat(Set<T> ... sets) {
        HashSet<T> result = new HashSet<T>();
        for (Set<T> set : sets) {
            result.addAll(set);
        }
        return Collections.unmodifiableSet(result);
    }

    @SafeVarargs
    public static <T> List<T> concat(List<T> ... lists) {
        ArrayList<T> result = new ArrayList<T>();
        for (List<T> list : lists) {
            result.addAll(list);
        }
        return Collections.unmodifiableList(result);
    }

    public static String[] concat(String[] array1, String[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        int length = length1 + length2;
        String[] dest = new String[length];
        System.arraycopy(array1, 0, dest, 0, length1);
        System.arraycopy(array2, 0, dest, length1, length2);
        return dest;
    }

    public static String[] concat(String[] ... arrays) {
        int destSize = 0;
        for (int i = 0; i < arrays.length; ++i) {
            destSize += arrays[i].length;
        }
        String[] dest = new String[destSize];
        int lastIndex = 0;
        for (int i = 0; i < arrays.length; ++i) {
            String[] array = arrays[i];
            System.arraycopy(array, 0, dest, lastIndex, array.length);
            lastIndex += array.length;
        }
        return dest;
    }

    public static boolean containsIgnoreCase(String[] array, String searchedText) {
        if (array == null || array.length == 0 || searchedText == null) {
            return false;
        }
        String compareValue = searchedText.toLowerCase();
        for (int i = 0; i < array.length; ++i) {
            String arrayValue = Objects.toString(array[i]).toLowerCase();
            if (!arrayValue.contains(compareValue)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static final <T> List<T> unmodifiableList(T ... args) {
        return Collections.unmodifiableList(Arrays.asList(args));
    }

    public static <E> Set<E> newLinkedHashSet(E ... elements) {
        LinkedHashSet set = new LinkedHashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static Class tryToLoadClassForName(String name) {
        try {
            return LangUtils.loadClassForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class loadClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, LangUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return Class.forName(name, false, LangUtils.getContextClassLoader());
        }
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getCurrentClassLoader(Class clazz) {
        ClassLoader cl = LangUtils.getContextClassLoader();
        if (cl == null && clazz != null) {
            cl = clazz.getClassLoader();
        }
        return cl;
    }

    public static Class getUnproxiedClass(Class currentClass) {
        Class unproxiedClass = currentClass;
        while (LangUtils.isProxiedClass(unproxiedClass)) {
            unproxiedClass = unproxiedClass.getSuperclass();
        }
        return unproxiedClass;
    }

    public static boolean isProxiedClass(Class currentClass) {
        if (currentClass == null || currentClass.getSuperclass() == null) {
            return false;
        }
        String name = currentClass.getName();
        return name.startsWith(currentClass.getSuperclass().getName()) && (name.contains("$$") || name.contains("_ClientProxy") || name.contains("$HibernateProxy$"));
    }

    public static Class<?> getTypeFromCollectionProperty(Object base, String property) {
        try {
            HashMap<Type, Type> genericTypeArgs2ActualTypeArgs = new HashMap<Type, Type>();
            Class baseClass = LangUtils.getUnproxiedClass(base.getClass());
            Type genericSuperclass = baseClass.getGenericSuperclass();
            for (Class superClass = baseClass.getSuperclass(); superClass != null && genericSuperclass != null; superClass = superClass.getSuperclass()) {
                if (genericSuperclass instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
                    List<Type> actualTypeArgs = Arrays.asList(parameterizedType.getActualTypeArguments());
                    if (parameterizedType.getRawType() instanceof Class) {
                        Class rawSuperClass = (Class)parameterizedType.getRawType();
                        List genericTypeArgs = Arrays.asList(rawSuperClass.getTypeParameters());
                        for (int i = 0; i < genericTypeArgs.size(); ++i) {
                            genericTypeArgs2ActualTypeArgs.put(genericTypeArgs.get(i), actualTypeArgs.get(i));
                        }
                    }
                }
                genericSuperclass = superClass.getGenericSuperclass();
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(baseClass);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if (!pd.getName().equals(property)) continue;
                Method getter = pd.getReadMethod();
                if (getter.getGenericReturnType() instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)getter.getGenericReturnType();
                    Type listType = pt.getActualTypeArguments()[0];
                    if (listType instanceof TypeVariable) {
                        TypeVariable typeVar = (TypeVariable)listType;
                        Type typeVarResolved = (Type)genericTypeArgs2ActualTypeArgs.get(typeVar);
                        return LangUtils.loadClassForName(typeVarResolved.getTypeName());
                    }
                    return LangUtils.loadClassForName(listType.getTypeName());
                }
                break;
            }
        }
        catch (IntrospectionException | ClassNotFoundException e) {
            throw new FacesException((Throwable)e);
        }
        return null;
    }

    public static String md5Hex(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            return DatatypeConverter.printHexBinary((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static String toCapitalCase(String value) {
        if (LangUtils.isValueBlank(value)) {
            return "";
        }
        CharSequence[] values = CAPITAL_CASE.split(value);
        if (values.length > 0) {
            values[0] = ((String)values[0]).substring(0, 1).toUpperCase() + ((String)values[0]).substring(1).toLowerCase();
        }
        return String.join((CharSequence)" ", values);
    }

    public static boolean isNumeric(String str) {
        if (LangUtils.isValueEmpty(str)) {
            return false;
        }
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return LangUtils.withDecimalsParsing(str, 1);
        }
        return LangUtils.withDecimalsParsing(str, 0);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;
        for (int i = beginIdx; i < str.length(); ++i) {
            boolean isDecimalPoint;
            boolean bl = isDecimalPoint = str.charAt(i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (isDecimalPoint || Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

